<?php
#chdir("../../../../");

require_once 'includes/Loader.php';
require_once 'include/utils/utils.php';
require_once 'libraries/Smarty/libs/Smarty.class.php';
vimport('includes.http.Request');
vimport('includes.runtime.Globals');
vimport('includes.runtime.BaseModel');
vimport ('includes.runtime.Controller');
vimport('includes.runtime.LanguageHandler');

Class relatedField_Setting{
    static $tableName = "complemento_fieldmodulerel";
    static $tableNameCondition = "complemento_fieldmodulerel_conditions";

    static function getCustomView_field($param)
    {
        global $adb;
        #$adb->setDebug(true);
        $relmodule = $param['module'];
        $src_field = $param['src_field'];
        $src_module = $param['src_module'];

        #Busca el fieldid del campo
        $q = $adb->pquery("SELECT f.fieldid FROM vtiger_field f JOIN vtiger_tab t ON t.tabid = f.tabid WHERE f.fieldname = ? AND t.name = ?",[$src_field,$src_module]);

        if($adb->num_rows($q) > 0)
        {
            $fieldid = $adb->query_result($q,0,'fieldid');
            #Busca si tiene una configuración de campo relacionado
            $as = $adb->pquery("SELECT cvid FROM ".self::$tableName." WHERE fieldid = ? AND relmodule = ?",[$fieldid,$relmodule]);
            if($adb->num_rows($as) > 0)
            {
                $cvid = $adb->query_result($as,0,'cvid');
            }    
        }

        return $cvid;
    }

    /**
     * Modifica la consulta para que cumpla las condiciones configuradas para un campo relacionado
     */
    static function listQuery_contitions(&$listQuery,$params){
        global $adb;
        #Busca si el campo relacionado tiene condiciones configuradas
        $a = $adb->pquery("SELECT fieldname_1, fieldname_2 FROM ".self::$tableNameCondition." WHERE module=? AND modulerel = ? AND fieldname = ?",[$params['src_module'],$params['module'],$params['src_field']]);
        if($adb->num_rows($a) > 0)
        {
            for ($i=0; $i < $adb->num_rows($a); $i++) { 
                $fieldname_1 = $adb->query_result($a,$i,'fieldname_1'); #Campo del modulo principal
                $fieldname_2 = $adb->query_result($a,$i,'fieldname_2'); #Campo del modulo a comparar
                if(!empty($params['fieldmodulerel_values'][$fieldname_1]))
                {
                    $val = $params['fieldmodulerel_values'][$fieldname_1];
                    $as = $adb->pquery("SELECT f.tablename, f.columnname FROM vtiger_field f JOIN vtiger_tab t ON t.tabid = f.tabid WHERE f.fieldname = ? AND t.name = ?",[$fieldname_2,$params['module']]);
                    $table_name = $adb->query_result($as,0,'tablename');
                    $columnname = $adb->query_result($as,0,'columnname');

                    #Si es una tabla "_cf" valida que se encuentra incluido en un JOIN
                    /*if(strpos($table_name,"cf_") !==false && strpos($listQuery,"JOIN ".$table_name)===false)
					    $listQuery = str_replace("WHERE","JOIN ".$table_name."cf ON vtiger_cotizaciones.cotizacionesid = vtiger_cotizacionescf.cotizacionesid WHERE",$listQuery);
                    */

				    $listQuery = str_replace("WHERE","WHERE $table_name.$columnname = $val AND ",$listQuery);
                }
            }
        }
    }
}