<?php

/*+**********************************************************************************
 * The contents of this file are subject to the vtiger CRM Public License Version 1.1
 * ("License"); You may not use this file except in compliance with the License
 * The Original Code is:  vtiger CRM Open Source
 * The Initial Developer of the Original Code is vtiger.
 * Portions created by vtiger are Copyright (C) vtiger.
 * All Rights Reserved.
 ************************************************************************************/

class Settings_LayoutEditor_Field_Action extends Settings_Vtiger_Index_Action {

    function __construct() {
		parent::__construct();
        $this->exposeMethod('add');
        $this->exposeMethod('save');
        $this->exposeMethod('delete');
        $this->exposeMethod('move');
        $this->exposeMethod('unHide');
		$this->exposeMethod('updateDuplicateHandling');
    }

    public function add(Vtiger_Request $request) {
        $type = $request->get('fieldType');
        $moduleName = $request->get('sourceModule');
        $blockId = $request->get('blockid');
        $moduleModel = Settings_LayoutEditor_Module_Model::getInstanceByName($moduleName);
        $response = new Vtiger_Response();
        try{
            $fieldModel = $moduleModel->addField($type,$blockId,$request->getAll());
            $fieldInfo = $fieldModel->getFieldInfo();
            $responseData = array_merge(array('id'=>$fieldModel->getId(), 'blockid'=>$blockId, 'customField'=>$fieldModel->isCustomField()),$fieldInfo);

			$defaultValue = $fieldModel->get('defaultvalue');
			$responseData['fieldDefaultValueRaw'] = $defaultValue;
			if (isset($defaultValue)) {
				if ($defaultValue && $fieldInfo['type'] == 'date') {
					$defaultValue = DateTimeField::convertToUserFormat($defaultValue);
				} else if (!$defaultValue) {
					$defaultValue = $fieldModel->getDisplayValue($defaultValue);
				} else if (is_array($defaultValue)) {
					foreach ($defaultValue as $key => $value) {
						$defaultValue[$key] = $fieldModel->getDisplayValue($value);
					}
					$defaultValue = Zend_Json::encode($defaultValue);
				}
			}
			$responseData['fieldDefaultValue'] = $defaultValue;
            self::UpdateFieldMappingTable($fieldModel);
            $response->setResult($responseData);
        }catch(Exception $e) {
            $response->setError($e->getCode(), $e->getMessage());
        }
        $response->emit();
    }

    public function save(Vtiger_Request $request) {
		$currentUser = Users_Record_Model::getCurrentUserModel();
        $fieldId = $request->get('fieldid');
        $sourceModule = $request->get('sourceModule');

        $moduleInstance = Vtiger_Module_Model::getInstance($sourceModule);
        $fieldInstance = Settings_LayoutEditor_Field_Model::getInstance($fieldId, $moduleInstance);
        
        $fieldLabel = $fieldInstance->get('label');
        $mandatory = $request->get('mandatory',null);
        $presence = $request->get('presence',null);
        $quickCreate = $request->get('quickcreate',null);
        $summaryField = $request->get('summaryfield',null);
        $massEditable = $request->get('masseditable',null);
        $headerField = $request->get('headerfield',null);

		if (!$fieldLabel) {
			$fieldInstance->set('label', $fieldLabel);
		}
		if(!empty($mandatory)){
            $fieldInstance->updateTypeofDataFromMandatory($mandatory);
        }
        if(!empty($presence)){
            $fieldInstance->set('presence', $presence);
        }
        
        if(!empty($quickCreate)){
            $fieldInstance->set('quickcreate', $quickCreate);
        }
        
        if(isset($summaryField) && $summaryField != null){
            $fieldInstance->set('summaryfield', $summaryField);
        }
        
        if(isset($headerField) && $headerField != null){
            $fieldInstance->set('headerfield', $headerField);
        }
        
        if(!empty($massEditable)){
            $fieldInstance->set('masseditable', $massEditable);
        }

		$defaultValue = decode_html($request->get('fieldDefaultValue'));
		$fieldInstance->set('defaultvalue', $defaultValue);
		$response = new Vtiger_Response();
        try{
            $fieldInstance->save();
			$fieldInstance = Settings_LayoutEditor_Field_Model::getInstance($fieldId);
			$fieldLabel = decode_html($request->get('fieldLabel'));
			$fieldInfo = $fieldInstance->getFieldInfo();
			$fieldInfo['id'] = $fieldInstance->getId();

			$fieldInfo['fieldDefaultValueRaw'] = $defaultValue;
			if (isset($defaultValue)) {
				if ($defaultValue && $fieldInfo['type'] == 'date') {
					$defaultValue = DateTimeField::convertToUserFormat($defaultValue);
				} else if (!$defaultValue) {
					$defaultValue = $fieldInstance->getDisplayValue($defaultValue);
				} else if (is_array($defaultValue)) {
					foreach ($defaultValue as $key => $value) {
						$defaultValue[$key] = $fieldInstance->getDisplayValue($value);
					}
					$defaultValue = Zend_Json::encode($defaultValue);
				}
			}
			$fieldInfo['fieldDefaultValue'] = $defaultValue;
            self::UpdateFieldMappingTable($fieldInstance);
            $response->setResult(array_merge(array('success'=>true), $fieldInfo));
        }catch(Exception $e) {
			$response->setError($e->getCode(), $e->getMessage());
		}
		$response->emit();
	}

    public function delete(Vtiger_Request $request) {
        $fieldId = $request->get('fieldid');
        $fieldInstance = Settings_LayoutEditor_Field_Model::getInstance($fieldId);
        $response = new Vtiger_Response();

        if(!$fieldInstance->isCustomField()) {
            $response->setError('122', 'Cannot delete Non custom field');
            $response->emit();
            return;
        }

        try{
            $this->_deleteField($fieldInstance);
            self::UpdateFieldMappingTable($fieldInstance,'delete');
        }catch(Exception $e) {
            $response->setError($e->getCode(), $e->getMessage());
        }
        $response->emit();
    }
    
    private function _deleteField($fieldInstance) {
        $sourceModule = $fieldInstance->get('block')->module->name;
        $fieldLabel = $fieldInstance->get('label');
        if($fieldInstance->uitype == 16 || $fieldInstance->uitype == 33){
            $pickListValues = $fieldInstance->getEditablePicklistValues ($fieldInstance->name);
            $fieldLabel = array_merge(array($fieldLabel),$pickListValues);
        }
        $fieldInstance->delete();
//        Settings_LayoutEditor_Module_Model::removeLabelFromLangFile($sourceModule, $fieldLabel);
        //we should delete any update field workflow associated with custom field
        $moduleName = $fieldInstance->getModule()->getName();
        Settings_Workflows_Record_Model::deleteUpadateFieldWorkflow($moduleName, $fieldInstance->getFieldName());
    }

    public function move(Vtiger_Request $request) {
        
        $updatedFieldsList = $request->get('updatedFields');
        
        // for Clearing cache we need Module Model
        $sourceModule = $request->get('selectedModule');
        $moduleModel = Vtiger_Module_Model::getInstance($sourceModule);
        
		//This will update the fields sequence for the updated blocks
        Settings_LayoutEditor_Block_Model::updateFieldSequenceNumber($updatedFieldsList,$moduleModel);
        self::UpdateFieldMappingTable();
        $response = new Vtiger_Response();
		$response->setResult(array('success'=>true));
        $response->emit();
    }

    public function unHide(Vtiger_Request $request) {
        $response = new Vtiger_Response();
        try{
			$fieldIds = $request->get('fieldIdList');
            Settings_LayoutEditor_Field_Model::makeFieldActive($fieldIds, $request->get('blockId'),$request->get('selectedModule'));
			$responseData = array();
			foreach($fieldIds as $fieldId) {
				$fieldModel = Settings_LayoutEditor_Field_Model::getInstance($fieldId);
				$fieldInfo = $fieldModel->getFieldInfo();
				$responseData[] = array_merge(array('id'=>$fieldModel->getId(), 'blockid'=>$fieldModel->get('block')->id, 'customField'=>$fieldModel->isCustomField()),$fieldInfo);
			}
            $response->setResult($responseData);
        }catch(Exception $e) {
            $response->setError($e->getCode(), $e->getMessage());
        }
        $response->emit();

    }

	public function updateDuplicateHandling(Vtiger_Request $request) {
		$response = new Vtiger_Response();
		try {
			$sourceModule = $request->get('sourceModule');
			$moduleModel = Settings_LayoutEditor_Module_Model::getInstanceByName($sourceModule);

			$fieldIdsList = $request->get('fieldIdsList');
			$result = $moduleModel->updateDuplicateHandling($request->get('rule'), $fieldIdsList, $request->get('syncActionId'));

			$response->setResult($result);
		} catch (Exception $e) {
			$response->setError($e->getCode(), $e->getMessage());
		}
		$response->emit();
	}

    public function validateRequest(Vtiger_Request $request) {
        $request->validateWriteAccess();
    }

    /**
     * Funtion que se encarga de actualizar la tabla de mapeo de campos.
     */
    static function UpdateFieldMappingTable($fieldModel = null, $action = '')
    {
        global $adb, $site_URL, $dbconfig;
        #Webservice para crear tabla
        file_get_contents($site_URL."/complemento/module/basic/controller/generar_campo.php?action=create_logtable");
        
        /**
         * Si se le pasa un campo como parámetro a la función, solo procede a actualizar los datos de ese campo.
         */
        if(!empty($fieldModel))
        {
            $fieldInfo = $fieldModel->getFieldInfo();
            $fieldname = str_replace("&#039;","",decode_html($fieldInfo["column"]));
            #Verifica si el campo existe en la tabla de mapeo
            $r = $adb->pquery("SELECT 1 FROM log_fieldallmodule WHERE columna_database = ? LIMIT 1",[$fieldname]);
            #Mapeo de Campo
            $mapp["tabla"]              = $fieldModel->get('table');
            $mapp["bloque_name"]        = decode_html($fieldModel->block->label);
            $mapp["bloque_sequence"]    = $fieldModel->block->sequence;
            $mapp["uitype"]             = $fieldModel->get('uitype');
            $mapp["displaytype"]        = $fieldModel->displaytype;
            $mapp["label_view"]         = $fieldInfo["label"];
            $mapp["columna_database"]   = $fieldInfo["column"];
            $mapp["columna_sequence"]   = $fieldModel->sequence;
            $mapp["defaultvalue"]       = $fieldInfo["defaultvalue"];
            $mapp["quickcreate"]        = $fieldInfo["quickcreate"];
            $mapp["masseditable"]       = $fieldInfo["masseditable"];
            $mapp["summaryfield"]       = $fieldInfo["isSummaryField"];
            $mapp["headerfield"]        = $fieldModel->headerfield;
            $mapp["columntype_database"] = $fieldInfo["fieldTypeLabel"];
            $mapp["picklist"]           = ($mapp["uitype"] == 15 || $mapp["uitype"] == 16 || $mapp["uitype"] == 33) ? json_encode($fieldInfo['picklistvalues'],JSON_UNESCAPED_UNICODE) : "";
            $mapp["mandatory"]          = $fieldInfo["mandatory"];
            $mapp["module"]             = $fieldModel->module->id;
            $mapp["typeofdata"]         = $fieldModel->typeofdata;
            #debug($fieldModel); die;
            $rq = "SELECT * from information_schema.COLUMNS where TABLE_SCHEMA = ? AND COLUMN_NAME = ?";
            $arq = $adb->pquery($rq,[$dbconfig["db_name"],$fieldInfo["column"]]);
            $mapp["column_type"] = $adb->query_result($arq,0,'column_type');

            if($adb->num_rows($r) == 0)
            {
                if($action != 'delete')
                {
                   
                    #Insert
                    #$adb->setDebug(true);
                    $adb->pquery("INSERT INTO log_fieldallmodule (".implode(",",array_keys($mapp)).") VALUES ('".implode("','",$mapp)."')");
                    #$adb->setDebug(false);
                }
                
            }
            else{
                if($action == 'delete')
                {
                    $adb->pquery("DELETE FROM log_fieldallmodule WHERE columna_database = ? LIMIT 1",[$fieldname]);
                }
                else{
                    #Update
                    $tx = "";
                    $i = 0;
                    foreach ($mapp as $column => $v) {
                        $i++;
                        $tx .= "$column='".$v."'";
                        $tx .= $i == count($mapp) ? "" : ", ";
                        
                    }

                    #$adb->setDebug(true);
                    $adb->pquery("UPDATE log_fieldallmodule SET $tx WHERE columna_database = ? LIMIT 1",[$fieldname]);
                    #$adb->setDebug(false);
                }
                
            }
        }
        else{
            /**
             * Si no se le especifica un campo recorre toda la tabla y actualiza todos los campos 
             */

            $f = $adb->pquery("SELECT f.fieldid, l.columna_database, t.name FROM log_fieldallmodule l JOIN vtiger_tab t ON t.tabid = l.module JOIN vtiger_field f ON f.fieldname = l.columna_database");
            if($adb->num_rows($f)> 0)
            {
                for ($i=0; $i < $adb->num_rows($f); $i++) { 
                    $fieldId = $adb->query_result($f,$i,'fieldid');
                    #debug($fieldId);
                    $fieldInstance = Settings_LayoutEditor_Field_Model::getInstance($fieldId);
                    self::UpdateFieldMappingTable($fieldInstance);
                }
                
            }
        }
    }
}
