<?php
require_once 'includes/runtime/Globals.php';
require_once 'include/utils/VtlibUtils.php';
require_once "include/utils/utils.php";

Class SC_Integration {
    public $Token = '';
    private $Token_lifespan = 3600; #24 Horas

    public function __construct()
    {
    }
    
    /**
     * Realiza una solicitud HTTP utilizando cURL.
     *
     * Esta función permite realizar solicitudes HTTP utilizando la librería cURL de PHP.
     * Puede ser utilizada para enviar datos POST, GET y configurar encabezados personalizados.
     *
     * @param string $method       El método HTTP a utilizar (por ejemplo, "GET" o "POST").
     * @param array  $params       Los parámetros de la solicitud, incluyendo opciones como "file", "postBody", "headers", etc.
     *
     * @return array|null          Un arreglo que contiene el encabezado de la respuesta, el cuerpo de la respuesta (decodificado como JSON)
     *                            y el código de estado HTTP, o NULL si se produce un error.
     */
    static function sendHTPP_request($params = null,$method = 'GET')
    {
        global $current_user, $domain_yavu;
        #Activar para debuggear request
        $debug = false;
       


        if(!empty($params['file']) && file_exists($params['file']))
        {
            $cf = new CURLFile($params['file'],'application/octet-stream','file.txt');
            $postBody["parametros"] = json_encode($params["postBody"]);
            $postBody["archivo"] = $cf;
            $headers = [
                "Content-Type: multipart/form-data",
            ];
        }
        else{
 
        $postBody = (!empty($params["postBody"])) ? json_encode($params["postBody"]) : NULL;
            $headers = [
                #"Accept: application/json",
                #"Content-Type: application/json",
            ];
        }

        if(!empty($_SESSION['scToken']['token']))
        {
            $headers[] = "Authorization: Bearer ".$_SESSION['scToken']['token'];
        }

        $segment = (isset($params["segment"])) ? "/".$params["segment"] : NULL;
        $getParam = isset($params["getParam"]) ? "?".http_build_query($params["getParam"]) : NULL;
        
        if($debug)
        {
            ob_start();  
            $out = fopen('php://output', 'w');
        }
        
        if(!empty($params["headers"]))
        {
        foreach ($params["headers"] as $key => $value) {
                $headers[] = "$key: $value";
            }
        }

        $url = $domain_yavu.$segment.$getParam;
        
        $opt = [
            CURLOPT_URL => $url,
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => "",
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 0,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => strtoupper($method),
            CURLOPT_POSTFIELDS => $postBody,
            CURLOPT_POST => true,
            CURLOPT_HTTPHEADER => $headers,
            CURLOPT_SSL_VERIFYHOST => FALSE,
            CURLOPT_SSL_VERIFYPEER => FALSE,
            CURLOPT_HEADER => 1,
        ];


        $curl = curl_init();
        curl_setopt_array($curl, $opt);

 
        if($debug)
        {
            curl_setopt($curl, CURLOPT_VERBOSE, TRUE);  
            curl_setopt($curl, CURLOPT_STDERR, $out);  
        }
        $response = curl_exec($curl);

      

        $header_size = curl_getinfo($curl, CURLINFO_HEADER_SIZE); 
        list($header, $body) = explode("\r\n\r\n", $response, 2);

        $err = curl_error($curl);
        curl_close($curl);
   
     
            #fclose($out);  
            #$debug = ob_get_clean();
            #debug($debug,true);

            // For debugging
            $debug_info = [
                'url' => $url,
                'method' => $method,
                'headers_sent' => $header,
                'post_data' => $postBody,
                'curl_options' => $curlOptions,
                'response' => $response,
                'http_code' => curl_getinfo($curl, CURLINFO_HTTP_CODE),
                'total_time' => curl_getinfo($curl, CURLINFO_TOTAL_TIME),
                'connect_time' => curl_getinfo($curl, CURLINFO_CONNECT_TIME),
                'name_lookup_time' => curl_getinfo($curl, CURLINFO_NAMELOOKUP_TIME),
                'pretransfer_time' => curl_getinfo($curl, CURLINFO_PRETRANSFER_TIME),
                'redirect_time' => curl_getinfo($curl, CURLINFO_REDIRECT_TIME),
                'effective_url' => curl_getinfo($curl, CURLINFO_EFFECTIVE_URL),
                'primary_ip' => curl_getinfo($curl, CURLINFO_PRIMARY_IP),
                'local_ip' => curl_getinfo($curl, CURLINFO_LOCAL_IP),
                'local_port' => curl_getinfo($curl, CURLINFO_LOCAL_PORT),
                'size_upload' => curl_getinfo($curl, CURLINFO_SIZE_UPLOAD),
                'size_download' => curl_getinfo($curl, CURLINFO_SIZE_DOWNLOAD),
            ];
            /** *
            if($method == 'POST')
            {
                echo '<pre>'; print_r($debug_info); echo '</pre>';
            }// */

        if ($err) {
            $result['code'] = $httpCode;
            $result['error'] = "cURL Error #:" . $err;
            $result['success'] = false;
            $result['debug'] = $debug_info ?? $debug;
        } else {
            $result['header'] 	= $header;
            $result['body'] 	= json_decode($body,true);
            $result['http_status'] = curl_getinfo($curl, CURLINFO_RESPONSE_CODE);
            $result['url'] = $domain_yavu;
            $result['params'] = $params;
            $result['debug'] = $debug_info ?? $debug;
            $result['code'] = 200;
        }

      

        return $result;
        
    }

    /**
     * Determina si un valor está en el formato '/Date(...)/'.
     *
     * @param string $value El valor a verificar.
     * @return bool True si el valor está en el formato '/Date(...)/', false en caso contrario.
     */
    public static function esFormatoFecha($value) {
        return (strpos($value, '/Date(') === 0 && strpos($value, ')/') !== false);
    }

    /**
     * Convierte una cadena de tiempo en formato '/Date(...)/' a una cadena de fecha y hora en el formato 'Y-m-d H:i:s'.
     *
     * @param string $timeString La cadena de tiempo en formato '/Date(...)/'.
     * @return string|null La cadena de fecha y hora en formato 'Y-m-d H:i:s' o null si hay un error.
     */
    public static function convertirFecha($timeString) {
        // Extraer la parte numérica de la cadena de tiempo
        preg_match('/\((\d+)-(\d+)\)/', $timeString, $matches);
    
        if (count($matches) >= 3) {
            $timestamp = $matches[1] / 1000; // Convertir milisegundos a segundos
            $timezoneOffset = $matches[2];
    
            // Crear un objeto DateTime ajustando la zona horaria
            $datetime = new DateTime("@$timestamp");
            $timezoneHours = substr($timezoneOffset, 0, 3);
            $timezoneMinutes = substr($timezoneOffset, 3);
            $timezone = ($timezoneHours >= 0 ? '+' : '-') . $timezoneHours . ' hours ' . $timezoneMinutes . ' minutes';
            $datetime->modify($timezone);
    
            return $datetime->format('Y-m-d H:i:s');
        } else {
            // No se pudo extraer la parte numérica y la zona horaria
            return null;
        }
    }

    /**
     * Cambia los nombres de las claves en un arreglo según un mapeo dado.
     *
     * @param array $arreglo El arreglo original.
     * @param array $mapeoNombres El mapeo de nombres de claves (clave original => nueva clave).
     * @return array El arreglo modificado con los nombres de claves cambiados.
     */
    public static function renombrarClaves($arreglo, $mapeoNombres) {
        $arregloModificado = array();
        foreach ($arreglo as $clave => $valor) {
            // Verificar si hay una clave en el mapeo y usarla si existe, de lo contrario, mantener la clave original
            if($mapeoNombres[$clave] && !is_array($mapeoNombres[$clave])){
            $nuevaClave = isset($mapeoNombres[$clave]) ? $mapeoNombres[$clave] : $clave;
            $arregloModificado[$nuevaClave] = $valor;
            }else{
            $arregloModificado[$clave] = $valor;

            }

        }
        //echo '<pre>'; print_r($arregloModificado); die();

        return $arregloModificado;
    }


    /**
     * Recorre un array y convierte los valores de fecha y hora en el formato '/Date(...)/' a 'Y-m-d H:i:s'.
     *
     * @param array $array El array de datos.
     * @param array|null $mapeoNombres El mapeo de nombres de claves (clave original => nueva clave) o null si no se proporciona.
     * @return array El array modificado con las fechas convertidas y las claves cambiadas si se proporciona un mapeo.
     */
    public static function procesarArray($array, $mapeoNombres = null) {
        foreach ($array as &$item) {
            //$item['Suministros'] ='';
        //echo '<pre>'; print_r($item); die();
            
            /*foreach ($item as $key => $value) {
                if (self::esFormatoFecha($value)) {
                    $item[$key] = self::convertirFecha($value);
                }
            }*/
            if ($mapeoNombres !== null) {
                // Cambiar las claves si se proporciona un mapeo de nombres
                $item = self::renombrarClaves($item, $mapeoNombres);
            }
        }
        return $array;
    }



    /**
     * Verifica si un valor existe en una tabla Picklist y lo crea si no existe.
     *
     * @param string $campo - El nombre de la tabla Picklist.
     * @param string $valor - El valor que se desea verificar y crear si no existe.
     *
     * @return void
     */
    public static function VerificarAndCrearRegistroPicklist($campo, $valor, $uitype) {
        global $adb, $current_user;

        if( (string) $uitype ==='16' || (string) $uitype ==='15'){
            // Consulta para verificar si el valor ya existe
            $sql = "SELECT * FROM `vtiger_{$campo}` WHERE {$campo} = '{$valor}' LIMIT 1";
            $rs = $adb->pquery($sql);
            
            if (!$adb->num_rows($rs)) {

                if((string) $uitype ==='16'){
                // Inserción de un nuevo registro
                $insert = "INSERT INTO `vtiger_{$campo}` (`{$campo}id`, `{$campo}`, `sortorderid`, `presence`, `color`) VALUES (null, '{$valor}', 0, 1, '');";
                }

                if((string) $uitype ==='15'){
                    $sql = "SELECT picklist_valueid +1 as newvalue, sortorderid+1 as newsortorderid FROM `vtiger_{$campo}` ORDER BY picklist_valueid desc limit 1";
                    $rs = $adb->pquery($sql);
                    $newvalue = $adb->query_result($rs, 0, 'newvalue'); 
                    $newsortorderid = $adb->query_result($rs, 0, 'newsortorderid'); 
                    $insert = "INSERT INTO `vtiger_{$campo}` (`{$campo}id`, `{$campo}`, `presence`, `picklist_valueid`, `sortorderid`, `color`) VALUES (null, '{$valor}', 1, {$newvalue}, {$newsortorderid}, '');";
                }

                $rs = $adb->pquery($insert);
                $recordId = $adb->getLastInsertID();
                // Actualización de la secuencia
                $update = "UPDATE `vtiger_{$campo}_seq` SET `id` = $recordId LIMIT 1";
                $rs = $adb->pquery($update);
                //echo '<pre>'; print_r($campo); echo '<br>';print_r($key); echo '<br>'; print_r($valor); echo '</pre>';

            }
        }

    }

    /**
     * Obtener el id del usuario 
     *
     * @param [type] $username
     * @return void
     */
    public static function VT_UserExiste($username){
        global $adb, $current_user;
        $sql="SELECT id FROM vtiger_users WHERE user_name like '%{$username}%' limit 1";
        $rs = $adb->pquery($sql);
        $userid = $adb->query_result($rs, 0, 'id');

        return ($userid !='' )? $userid : '15';
        //return $adb->query_result($rs, 0, 'id'); 
    }

    /**
     * Restar y sumar dias a la fecha actual
     *
     * @param [string] $days
     * @return date
     */
    public static function SumarRestarDaysADate($days) {
        $currentDate = date('Y-m-d');
        $newDate = date('Y-m-d', strtotime($currentDate . ' ' . ($days >= 0 ? '+' : '-') . abs($days) . ' days'));
        return $newDate;
    }

    /**
     * Crear relacion de registro entre modulos 
     *
     * @param [type] $record 
     * @param [type] $relationId 
     * @return void
     */
    public static function addRelacionForIds($record, $relationId){
        $obj= (object) ['setRelation' => (object) [] ];
 		$relationModel = Vtiger_Relation_Model::getInstance(Vtiger_Record_Model::getInstanceById($record)->getModule(), Vtiger_Record_Model::getInstanceById($relationId)->getModule());
        $relationModel->addRelation($record,$relationId);

        $obj->setRelation->record     = $record;
        $obj->setRelation->relationId = $relationId;
        
        return $obj;
    }
    
    public function conversion_Kw_MW($value){
        return $value ? round((float)$value / 1000,2): $value;
    }
    private static function unsetNumericKeys($array) {

        foreach ($array as $key => $value) {
            // Verificar si la clave es numérica, incluso si es un string que representa un número
            if (is_numeric($key)) {
             echo '<pre>'; print_r( $array ); die;
             unset($array[$key]);
            }
        }
        return $array;
    }
   
    public static function setModelVtiger($module, $data, $id = '', $edit = false){
        
        if($id && $edit === false) return $id;

        global $adb, $current_user;				
        $current_user = Users::getActiveAdminUser();

        if(!$module && !$data) return $data;
        
        // Si $data es un objeto, lo transformamos en un array
        if (is_object($data)) $data = get_object_vars($data);

        if($id){
            $mode='edit';
            $model = Vtiger_Record_Model::getInstanceById($id); // internamente busca el módulo
        }else{
            $mode='';
            $model = Vtiger_Record_Model::getCleanInstance($module);
            $model->set('assigned_user_id','1');
        }

            //$adb->setDebug(1);
            $model->set('mode',$mode); // lo preparas para el insert
    
            foreach ( ($data) as $key => $value) {
                
                self::VerificarAndCrearRegistroPicklist($key, $value, $model->getField($key)->uitype);
                $model->set($key, $value);
                
            }
            $model->set('source','SERVICE');

            // $obj["{$key}"]->id= $model->getId();
            // echo '<pre>'; print_r($model->getData()); echo '</pre>';// die;
            // $model->getData(); 

            $model->save();
            $crmid = $model->getId();

            if($data['createdtime']) self::createdtime_Update( $data['createdtime'], $crmid);
            
        return $crmid;
    }

    private function createdtime_Update( $createdtime, $crmid){
        if(!$createdtime && !$crmid) return false;

        global $adb, $current_user;				
        $current_user = Users::getActiveAdminUser();
        $sql="UPDATE `vtiger_crmentity` SET `createdtime` = ? WHERE `crmid` = ?";
        $rs = $adb->pquery($sql, [ $createdtime, $crmid ]);
    }

    public function deleteLogicRegisterVtiger($crmid){
        if(!$crmid) return false;

        global $adb, $current_user;				
        $current_user = Users::getActiveAdminUser();
        $sql="UPDATE `vtiger_crmentity` SET `deleted` = ? WHERE `crmid` = ?";
        $rs = $adb->pquery($sql, [ 1, $crmid ]);
    }

    public static function escribirLog($objeto, $alias = null)
    {
        try {
            // Configurar zona horaria
            #date_default_timezone_set('America/Lima');
            date_default_timezone_set('America/Argentina/Buenos_Aires');

            // Definir nombre del archivo con alias opcional
            $prefix = $alias ? "{$alias}_" : "log_";
            $nombreArchivo = $prefix . date("Y_m") . ".log";
            
            // Preparar contenido del log
            $timestamp = date("Y-m-d H:i:s");
            $separador = str_repeat('-', 20);
            
            // Formatear el objeto para el log
            $contenidoLog = sprintf(
                "%s %s %s\n%s\n", 
                $separador, 
                $timestamp, 
                $separador,
                is_string($objeto) ? $objeto : json_encode($objeto, JSON_PRETTY_PRINT)
            );
            
            // Intentar escribir el log
            if (is_writable($nombreArchivo)) {
                error_log($contenidoLog . PHP_EOL, 3, $nombreArchivo);
            } else {
                // Si el archivo no existe o no se puede escribir, intentar crearlo
                if ($archivo = @fopen($nombreArchivo, 'a')) {
                    fwrite($archivo, $contenidoLog . PHP_EOL);
                    fclose($archivo);
                } else {
                    // Si no se puede crear/abrir el archivo, registrar en el log del sistema
                    error_log("No se pudo escribir en el archivo de log: " . $nombreArchivo);
                    error_log("Contenido del log: " . $contenidoLog);
                }
            }
            
            return true;
            
        } catch (Exception $e) {
            // Registrar el error en el log del sistema pero permitir que el programa continúe
            error_log("Error escribiendo log: " . $e->getMessage());
            return false;
        }
    }

    public static function restarDias($dias = 0, $horaActual = true)
    {
        try {
            // Configurar zona horaria
            date_default_timezone_set('America/Argentina/Buenos_Aires');
            
            // Obtener fecha actual
            $fecha = new DateTime();
            
            // Restar los días
            if ($dias > 0) {
                $fecha->sub(new DateInterval("P{$dias}D"));
            }
            
            // Si no queremos la hora actual, establecemos a 00:00
            if (!$horaActual) {
                $fecha->setTime(0, 0);
            }
            
            // Retornar en formato solicitado
            return $fecha->format('d/m/Y H:i');
            
        } catch (Exception $e) {
            return date('d/m/Y H:i'); // Retorna fecha actual si hay error
        }
    }
  
    public function flattenArray($value, $prefix = '') {
        $vt_data = [];
    
        array_walk_recursive($value, function($item, $key) use (&$vt_data, &$prefix) {
            $vt_data[$prefix . $key] = $item;
        });
    
        return $vt_data;
    }
    
    public function pkeyArray($value, $prefix = '') {
        $vt_data = [];
        $collections = [];
    
        foreach ($value as $key => $subvalue) {
            $newPrefix = $prefix ? $prefix . '_' . $key : $key;
    
            // Verificar si la clave contiene un número
            if (preg_match('/\d+$/', $key, $matches)) {
                $baseKey = preg_replace('/\d+$/', '', $newPrefix);
                $collections[$baseKey][] = $this->pkeyArray($subvalue, '');
            } else {
                if (is_array($subvalue)) {
                    $vt_data = array_merge($vt_data, $this->pkeyArray($subvalue, $newPrefix));
                } else {
                    $vt_data[$newPrefix] = $subvalue;
                }
            }
        }
    
        // Agregar las colecciones al resultado final
        foreach ($collections as $baseKey => $collection) {
            $vt_data[$baseKey] = $collection;
        }
    
        return $vt_data;
    }

    public function aplicarDiccionario($array, $mapeoNombres) {
        if (is_array($array) && isset($array[0])) {
            return  self::procesarArray(self::pkeyArray($array), $mapeoNombres);
        }else{
            return  self::procesarArray([self::pkeyArray($array)], $mapeoNombres);
        }
        
    }

    /**
     * Transforma un array con claves externas (Doubao) a claves internas usando el mapeo de db_mapeoNombres().
     *
     * @param array $array Array con claves externas.
     * @return array Array con claves internas mapeadas.
     */
    public static function reverseDiccionario($array, $mapeoNombres): array
    {
        $mapeo = array_filter($mapeoNombres); // filtra vacíos
        $inverso = array_flip($mapeo);

        $resultado = [];

        foreach ($array as $claveExterna => $valor) {
            if (isset($inverso[$claveExterna])) {
                $claveInterna = $inverso[$claveExterna];
                $resultado[$claveInterna] = $valor;
            }
        }

        return $resultado;
    }


    public static function extraerEmail($cadena) {
        // Usamos una expresión regular para buscar el correo electrónico
        if (preg_match('/[a-zA-Z0-9._%+-]+@[a-zA-Z0-9.-]+\.[a-zA-Z]{2,}/', $cadena, $matches)) {
            return $matches[0]; // Retorna el primer correo encontrado
        } else {
            return null; // Si no se encuentra ningún correo, retorna null
        }
    }

/*
    public static function PHPCURL_TOKEN() {
        //return self::getAccessToken();
        // Verify SSL certificate settings
        $curl = curl_init();

        $curlOptions = [
            #CURLOPT_PORT => "12910",
            CURLOPT_URL => "https://lvservicios.yavuerp.com.ar:12910/yavuws/token?client_secret=oauth2clientsecret&grant_type=password&client_id=yavuErp&username=crmlvws&password=LVS3rvic428",
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => "",
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 30,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => "POST",
            // Add these options to handle SSL/connection issues
            CURLOPT_SSL_VERIFYPEER => false,  // Disable SSL verification - use with caution
            CURLOPT_SSL_VERIFYHOST => 0,      // Disable host verification - use with caution
            CURLOPT_CONNECTTIMEOUT => 10,     // Connection timeout in seconds
            // Add headers if needed
            CURLOPT_HTTPHEADER => [
                //'Access-Control-Request-Method: POST',
                //'Access-Control-Request-Headers: Content-Type,Authorization,servers',
                'Content-Type: application/x-www-form-urlencoded',
                //'User-Agent: Mozilla/5.0', // Puedes añadir un User-Agent válido.
                //'Host: lvservicios.yavuerp.com.ar'  // Importante para virtual hosting
                //'Connection: keep-alive',
                //'Accept-Language: en-US,en;q=0.9',
            ]
            ];
        
        curl_setopt_array($curl, $curlOptions);
        
        // Add better error handling
        $response = curl_exec($curl);
        $err = curl_error($curl);
        $httpCode = curl_getinfo($curl, CURLINFO_HTTP_CODE);
        
        // For debugging
        $debug_info = [
            'url' => $url,
            'method' => 'POST',
            'headers_sent' => $headers,
            'post_data' => $postFields,
            'curl_options' => $curlOptions,
            'http_code' => curl_getinfo($curl, CURLINFO_HTTP_CODE),
            'total_time' => curl_getinfo($curl, CURLINFO_TOTAL_TIME),
            'connect_time' => curl_getinfo($curl, CURLINFO_CONNECT_TIME),
            'name_lookup_time' => curl_getinfo($curl, CURLINFO_NAMELOOKUP_TIME),
            'pretransfer_time' => curl_getinfo($curl, CURLINFO_PRETRANSFER_TIME),
            'redirect_time' => curl_getinfo($curl, CURLINFO_REDIRECT_TIME),
            'effective_url' => curl_getinfo($curl, CURLINFO_EFFECTIVE_URL),
            'primary_ip' => curl_getinfo($curl, CURLINFO_PRIMARY_IP),
            'local_ip' => curl_getinfo($curl, CURLINFO_LOCAL_IP),
            'local_port' => curl_getinfo($curl, CURLINFO_LOCAL_PORT),
            'size_upload' => curl_getinfo($curl, CURLINFO_SIZE_UPLOAD),
            'size_download' => curl_getinfo($curl, CURLINFO_SIZE_DOWNLOAD),
        ];

        
        curl_close($curl);
        
        if ($err) {
            error_log("cURL Error: " . $err);
            return ['success' => false, 'error' => $err, 'debug' => $debug_info];
        }

        $decoded_response = json_decode($response);
        $result = ['success' => true, 'data' => $decoded_response, 'debug' => $debug_info, 'resp_curl' => $response];

        return $response;
    }
    public function getAccessToken()
    {
        $data = $this->data;

        $curl = curl_init();

        $url = $this->generateUrl('/token', [
            'client_secret' => 'oauth2clientsecret',
            'grant_type' => 'password',
            'client_id' => 'yavuErp',
            'username' => 'crmlvws',
            'password' => 'LVS3rvic428',
        ]);

        curl_setopt_array($curl, array(
            CURLOPT_URL => $url,
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => '',
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 0,
            CURLOPT_FOLLOWLOCATION => true,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => 'POST',
            CURLOPT_SSL_VERIFYHOST => false,
            CURLOPT_SSL_VERIFYPEER => false,
            CURLOPT_HTTPHEADER => array(
                'Content-Type: application/x-www-form-urlencoded'
            ),
        ));

        $response = curl_exec($curl);
        $err = curl_error($curl);
        curl_close($curl);

        $data = json_decode($response, true);
        #echo '<pre>'; print_r([$err, $data]); die;
        $accessToken = $data['access_token'];

        return $accessToken;
    }


    public function generateUrl($path, $parameters = [])
    {
        $baseUrl = 'https://lvservicios.yavuerp.com.ar:12910/yavuws';
        if (!$parameters) {
            return $baseUrl . $path;
        }

        return $path . '?' . http_build_query($parameters);
    }
    */

}