<?php

class vtQuotes_model
{
    private $adb;

    public function __construct()
    {
        global $adb;
        $this->adb = $adb;
    }

    public function getQuotes($params = [])
    {
        
        $query = "SELECT * FROM vtiger_quotes";
        $conditions = [];

        if (!empty($params['search'])) {
            $conditions[] = "subject LIKE ?";
            $params['search'] = '%' . $params['search'] . '%';
        }
        if (!empty($params['potentialid'])) {
            $conditions[] = "potentialid = ?";
            $params['potentialid'] = $params['potentialid'];
        }
        if (!empty($params['quote_no'])) {
            $conditions[] = "quote_no = ?";
            $params['quote_no'] = $params['quote_no'];
        }
        if (!empty($params['quote_stage'])) {
            $conditions[] = "quote_stage = ?";
            $params['quote_stage'] = $params['quote_stage'];
        }
        if (!empty($params['assigned_user_id'])) {
            $conditions[] = "assigned_user_id = ?";
        }

        if (!empty($conditions)) {
            unset($params['useCase']);
            $query .= ' WHERE ' . implode(' AND ', $conditions);
        }
        #$this->adb->setDebug(true);
        $result = $this->adb->pquery($query, array_values($params));
        $count = (int) $this->adb->num_rows($result);
        while ($row = $this->adb->fetch_array($result)) {
            // solo key que no sean numericos
            $row = array_filter($row, function ($key) {
                return !is_numeric($key);
            }, ARRAY_FILTER_USE_KEY);
            $rows[] = $row;
        }
        #$this->adb->setDebug(false);
        return ['resp' => 'select', 'data' => $rows, 'count' => $count];
        //return vtlib\Functions::getAll($query, array_values($params));
    }

    public function getProductoRel($params = [])
    {
        
        $query = "SELECT * FROM vtiger_seproductsrel";
        $conditions = [];

        if (!empty($params['crmid'])) {
            $conditions[] = "crmid = ?";
            $params['crmid'] = $params['crmid'];
        }

        if (!empty($params['quantity'])) {
            $conditions[] = "quantity = ?";
            $params['quantity'] = $params['quantity'];
        }

        if (!empty($params['productid'])) {
            $conditions[] = "productid = ?";
            $params['productid'] = $params['productid'];
        }
        if (!empty($params['setype'])) {
            $conditions[] = "setype = ?";
            $params['setype'] = $params['setype'];
        }

        if (!empty($conditions)) {
            unset($params['useCase']);
            $query .= ' WHERE ' . implode(' AND ', $conditions);
        }
        #$this->adb->setDebug(true);
        $result = $this->adb->pquery($query, array_values($params));
        $count = (int) $this->adb->num_rows($result);
        while ($row = $this->adb->fetch_array($result)) {
            // solo key que no sean numericos
            $row = array_filter($row, function ($key) {
                return !is_numeric($key);
            }, ARRAY_FILTER_USE_KEY);
            $rows[] = $row;
        }
        #$this->adb->setDebug(false);
        return ['resp' => 'select', 'data' => $rows, 'count' => $count];
        //return vtlib\Functions::getAll($query, array_values($params));
    }


    public function getQuoteById($id)
    {
        $query = "SELECT * FROM vtiger_quotes WHERE quoteid = ?";
        return vtlib\Functions::getRow($query, [$id]);
    }


    /**
     * declaration en resources/CreantisJsFooter.js
     * obtener url de redireccionamiento para crear o editar una cotización
     * getQuoteSessionRedireccion
     * @param int $potentialid
     * @return array|object
     */
    private function getQuoteSessionRedireccion($potentialid)
    {
        $obj = ['resp' => 'error', 'msj' => 'No se ha enviado el potentialid o no es válido'];
        #print_r($obj);die;
        if($_SESSION['Vl_CreateQuote'] === (int) $potentialid  && $this->Validation_BussinesQuotePotential($potentialid) ) {
            $obj = $this->buildQuotesEditUrl(['potentialid' => $potentialid]);
        }else{
            unset($_SESSION['Vl_CreateQuote']);
        }
        return $obj;
    }

    private function Validation_BussinesQuotePotential($potentialid)
    {
        global $adb, $current_user;				
        $current_user = Users::getActiveAdminUser();
        $model = Vtiger_Record_Model::getInstanceById($potentialid); // internamente busca el módulo
        $potential = $model->getData();

        $data = $this->getQuotes(["potentialid" => $potentialid]);
        //$product = $this->getProductoRel(["crmid" => $potentialid, "setype" => "Potentials"]);
        //$boolean = ($data['count'] === 0 && $potential['related_to'] && $potential['contact_id'] && $product['count'] > 0) ? true : false;
        $boolean = ($data['count'] === 0 && $potential['related_to'] && $potential['contact_id']) ? true : false;
        //echo '<pre>'; var_dump($boolean);die;

        return $boolean;
    }

    /**
     * declaration en workflows/Potentials/GetRedireccion.inc
     * @param array $params => [
     *     'potentialid' => requerido, id del potential
     * ]
     * @return array|mixed
     */
    public function getSessionValidationRedireccionPotential($params)
    {

        if(!isset($params['potentialid']) || empty($params['potentialid'])) {
            unset($_SESSION['Vl_CreateQuote']);
            // si no se envia el potentialid, retornar error
            return ['resp' => 'requiere_potentialid', 'msj' => 'El parametro potentialid es requerido'];
        }

        $result = $this->Validation_BussinesQuotePotential($params['potentialid']);

        // no exista la cotización y que tenga cuenta y contacto relacionados
        if($result === true) {

            // si hay resultados, retornar la sesion de quote
            $_SESSION['Vl_CreateQuote'] = (int) $params['potentialid'];
        
        } else {
            // si no hay resultados, eliminar la sesion de quote
            unset($_SESSION['Vl_CreateQuote']);
        }

        // retornar todas las sesiones relacionadas que empiecen con Vl_
        return ['resp' => 'global', 'result' => array_filter($_SESSION, function ($key) {
            return strpos($key, 'Vl_') === 0;
        }, ARRAY_FILTER_USE_KEY)];
    }

    // index.php?module=Quotes&view=Edit&returnmode=showRelatedList&returntab_label=Quotes&returnrecord=9&returnmodule=Potentials&returnview=Detail&returnrelatedModuleName=Quotes&returnrelationId=35&relationOperation=true&potential_id=9&account_id=7&contact_id=8&app=SALES
    private function buildQuotesEditUrl(array $params = [])
    {
        global $adb, $current_user;				
        $current_user = Users::getActiveAdminUser();
        $model = Vtiger_Record_Model::getInstanceById($params['potentialid']); // internamente busca el módulo
        $potential = $model->getData();
        // Valores por defecto
        $defaults = [
            'module' => 'Quotes',
            'view' => 'Edit',
            'returnmode' => 'showRelatedList',
            'returntab_label' => 'Quotes',
            'returnrecord' => $params['potentialid'],
            'returnmodule' => 'Potentials',
            'returnview' => 'Detail',
            'returnrelatedModuleName' => 'Quotes',
            'returnrelationId' => 35,
            'relationOperation' => 'true',
            'potential_id' => $params['potentialid'],
            'account_id' => $potential['related_to'] ?? '',
            'contact_id' => $potential['contact_id'] ?? '',
            'app' => 'SALES',
        ];

        // Fusionar los valores por defecto con los parámetros recibidos
        $merged = array_merge($defaults, $params);

        // Convertir a string de URL
        return [
            'resp' => 'url',
            'url' => 'index.php?' . http_build_query($merged),
        ];
    }



    public function useCasePublic($params = [])
    {
        #print_r($params);die;

        switch ($params['useCase']) {
            case 'getQuotes':
                return self::getQuotes($params);
            case 'getQuoteById':
                return self::getQuoteById($params['id']);
            case 'getQuoteSessionRedireccion':
                return self::getQuoteSessionRedireccion($params['potentialid']);
        }

    }

}