

function addCopyToClipboardEvent(selectors) {
	selectors.forEach(function (selector) {
		var elements = document.querySelectorAll(selector);

		if (elements.length === 0) {
			console.error("No se encontraron elementos con el selector: " + selector);
			return;
		}

		elements.forEach(function (element) {
			element.addEventListener('click', function () {
				var formattedValue = element.getAttribute('data-formatted-value');

				var tempElement = document.createElement('textarea');
				tempElement.value = formattedValue;
				document.body.appendChild(tempElement);

				tempElement.select();
				document.execCommand('copy');

				document.body.removeChild(tempElement);

				// Muestra la notificación de éxito específica para este elemento
				app.helper.showSuccessNotification({ message: 'Valor Copiado: ' + formattedValue });
			});
		});
	});
}





/**
 * Formatea un número con la cantidad de decimales y los separadores especificados.
 *
 * @param {number} number - El número a formatear.
 * @param {number} [decimales=0] - La cantidad de decimales a mostrar.
 * @param {string} [separatorMiles=','] - El separador de miles.
 * @param {string} [separatorDecimal='.'] - El separador decimal.
 * @returns {string} - El número formateado como cadena.
 */
function formatNumber(number, decimales = 0, separatorMiles = ',', separatorDecimal = '.') {
	// Validar que 'decimales' sea un número positivo
	if (typeof decimales !== 'number' || decimales < 0) {
		console.error("El parámetro 'decimales' debe ser un número positivo.");
		return number.toString(); // Devuelve la cadena original si 'decimales' no es válido.
	}

	// Convertir 'number' a un objeto Number.
	var numberObj = new Number(number);

	// Multiplicar por 10^decimales para preservar los decimales
	var factor = Math.pow(10, decimales);
	var roundedNumber = Math.round(numberObj * factor) / factor;

	// Convertir el número redondeado en una cadena con el número correcto de decimales
	var formattedNumber = roundedNumber.toFixed(decimales);

	// Aplicar separadores de miles a la parte entera del número.
	var parts = formattedNumber.split('.');
	parts[0] = parts[0].replace(/\B(?=(\d{3})+(?!\d))/g, separatorMiles);

	// Unir las partes con el separador decimal adecuado
	var result = parts.join(separatorDecimal);
	// Verificar si el resultado es NaN después del formateo
	if (isNaN(parseFloat(result))) {
		//console.warn("El número después del formateo es NaN.");
		return number.toString(); // Devuelve la cadena original en caso de NaN.
	}

	// Devolver el resultado
	return result;
}





/**
 * Llena los campos de un formulario con datos de ubicación (ubigeo).
 *
 * @param {object} objubigeo - Objeto que contiene los valores de ubicación.
 * @param {object} objubigeo.pais - Objeto con información del país.
 * @param {string} objubigeo.pais.name - Nombre del campo de país.
 * @param {string} objubigeo.pais.value - Valor del país.
 * @param {object} objubigeo.departamento - Objeto con información del departamento.
 * @param {string} objubigeo.departamento.name - Nombre del campo de departamento.
 * @param {string} objubigeo.departamento.value - Valor del departamento.
 * @param {object} objubigeo.distrito - Objeto con información del distrito.
 * @param {string} objubigeo.distrito.name - Nombre del campo de distrito.
 * @param {string} objubigeo.distrito.value - Valor del distrito.
 * @param {object} objubigeo.provincia - Objeto con información de la provincia.
 * @param {string} objubigeo.provincia.name - Nombre del campo de provincia.
 * @param {string} objubigeo.provincia.value - Valor de la provincia.
 */
const Ubigeo_GetData = (objubigeo) => {
	let obj = {
		paisElemnt: select(`[name=${objubigeo.pais.name}]`),
		departamentoElemnt: select(`[name=${objubigeo.departamento.name}]`),
		distritoElemnt: select(`[name=${objubigeo.distrito.name}]`),
		provinciaElemnt: select(`[name=${objubigeo.provincia.name}]`),
	};
	if (obj.paisElemnt) obj.paisElemnt.value = objubigeo.pais.value;
	if (obj.departamentoElemnt) obj.departamentoElemnt.value = objubigeo.departamento.value;
	if (obj.distritoElemnt) obj.distritoElemnt.value = objubigeo.distrito.value;
	if (obj.provinciaElemnt) obj.provinciaElemnt.value = objubigeo.provincia.value;

	elementReadonly(true, obj.paisElemnt)
	elementReadonly(true, obj.departamentoElemnt)
	elementReadonly(true, obj.distritoElemnt)
	elementReadonly(true, obj.provinciaElemnt)
};



function FormatDobleAllView() {
	//console.log('FormatDobleAllView')
	let inputs = document.querySelectorAll('input[data-field]'); // Edit
	let spans = document.querySelectorAll('span[data-field-type="double"]');
	let tds = document.querySelectorAll('td[data-field-type="double"]');


	inputs.forEach(function (inputElement) {

		let dataField = JSON.parse(inputElement.dataset.field);
		if (dataField.type === "double") {
			let originalValue = inputElement.value.trim();

			//--- obtener configuracion del campo
			const miles = inputElement.getAttribute('data-group-separator', originalValue);
			const decimal = inputElement.getAttribute('data-number-of-decimal-places', originalValue);

			if (!miles && !decimal) return

			inputElement.value = formatNumber(originalValue, 2, miles, decimal);
			inputElement.setAttribute('data-value', originalValue);
		}
	});


	spans.forEach(function (span) {
		let originalValue = span.textContent.trim();
		//--- obtener configuracion del campo
		const miles = span.getAttribute('data-group-separator');
		const decimal = span.getAttribute('data-number-of-decimal-places');
		if (!miles && !decimal) return

		//console.log('span', span, miles, decimal)

		let formattedValue = formatNumber(originalValue, 2, miles, decimal);



		// Establecer el valor formateado como un atributo del td
		span.setAttribute('data-value', originalValue);
		span.textContent = formattedValue;
	});


	tds.forEach(function (td) {
		var originalValue = td.textContent.trim();

		const miles = td.getAttribute('data-group-separator', originalValue);
		const decimal = td.getAttribute('data-number-of-decimal-places', originalValue);
		if (!miles && !decimal) return
		let formattedValue = formatNumber(originalValue, 2, miles, decimal);

		// Establecer el valor formateado como un atributo del td
		td.setAttribute('data-value', originalValue);
		td.textContent = formattedValue;
	});
}



function FormatNumberAllView() {
	let inputs = document.querySelectorAll('input[data-field]'); // Edit
	let spans = document.querySelectorAll('span[data-field-type="integer"]');
	let tds = document.querySelectorAll('td[data-field-type="integer"]');

	inputs.forEach(function (inputElement) {
		let dataField = JSON.parse(inputElement.dataset.field)
		//console.log(inputElement, dataField.type)
		if (dataField.type === "integer") {
			let originalValue = inputElement.value.trim();
			inputElement.value = formatNumber(originalValue);
			inputElement.setAttribute('data-value', originalValue);
		}
	});

	spans.forEach(function (span) {
		var originalValue = span.textContent.trim();
		var formattedValue = formatNumber(originalValue);

		// Establecer el valor formateado como un atributo del td
		span.setAttribute('data-value', originalValue);
		span.textContent = formattedValue;
	});


	tds.forEach(function (td) {
		var originalValue = td.textContent.trim();
		var formattedValue = formatNumber(originalValue);

		// Establecer el valor formateado como un atributo del td
		td.setAttribute('data-value', originalValue);
		td.textContent = formattedValue;
	});
}
//------------------------./


async function GetRedireccion(potentialid) {
	try {
		const response = await fetch('integraciones/Quotes/controller/useCasePublic.php', {
			method: 'POST',
			headers: {
				'Content-Type': 'application/json',
			},
			body: JSON.stringify({
				useCase: 'getQuoteSessionRedireccion',
				potentialid: potentialid
			})
		});
		if (!response.ok) {
			throw new Error(`Error al obtener la URL: ${response.status}`);
		}

		const data = await response.json();
		console.log('GetRedireccion', data);
		if (data.resp === 'url') {
			debugger
			window.location.href = data.url;
		} else {
			console.error('La respuesta no contiene una URL válida:', data);
		}
	} catch (error) {
		console.error('Error en la redirección:', error);
	}
}



function PotentialsDetail_Init() {
	//GetRedireccion(_META.URL.record) // quitar redireccionamiento a peticion de sandro 2025-06-06
}
function QuotesEdit_Init() {
	requestData(_META.URL.module, 'GetData', _META.URL.potential_id)
		.then((data) => {
			if (!data['success']) return
			let dt = data.result.data;
			console.log('QuotesEdit_Init', dt);
			setFormValues('EditView', {
				subject: dt.label,
			})
		})
}


function AccountsEdit_Init() {
}



function ProdpotentialscalcularRestante() {	
	const compra = select('[name=lb_cantidadcompproduct]');
	const usada = select('[name=lb_cantidadusadaproduct]');
	const restante = select('[name=lb_cantidadrestanteproduct]');

  const compraVal = parseFloat(compra.value);
  const usadaVal = parseFloat(usada.value);

  if (!isNaN(compraVal) && !isNaN(usadaVal)) {
	restante.value = compraVal - usadaVal;
  } else {
	restante.value = '';
  }
}

function ProdpotentialsEdit_Init() {	

	elementReadonly(true, select('[name=lb_cantidadrestanteproduct]'))
	
	select('[name=lb_cantidadcompproduct]').addEventListener('input', ProdpotentialscalcularRestante);
	select('[name=lb_cantidadusadaproduct]').addEventListener('input', ProdpotentialscalcularRestante);
}


//------------------------./
/**
 * Executes a dynamically generated function based on the _META object.
 * 
 * @param {Object} _META - An object containing the module and view information.
 * @param {string} _META.module - The module name, e.g., 'Accounts'.
 * @param {string} _META.view - The view name, e.g., 'Edit'.
 */
function executeMetaFunction(_META) {
	if (!_META?.module || !_META?.view) {
		console.error('Invalid _META object: "module" and "view" keys are required.');
		return;
	}

	const functionName = `${_META.module}${_META.view}_Init`;

	// Define and execute the function if it doesn't exist
	(window[functionName] ||= () => CLog.fn(`Executing ${functionName}`))();
}

/**
 * Ejecutar funciones por Modulos y Vistas
 * 	Declarado
 * 		- layouts/v7/modules/Vtiger/resources/Popup.js => Se ejecuta luego de dar clic al valor del Popup* 	
 * 		- registerEventForListViewEntryClick : function() 
 * 			-dentro de esta funcion 'popupPageContentsContainer.on('click','.listViewEntries',function(e))'	
 * 			
 * @param {_META.module}	=> Modulo 
 * @param {_META.view}		=> Vista
 */
function CaseModules() {
	CLog.setDebug(true)

	_META.URL = purl(window.document.URL).data.param.query;
	//Object.freeze(_META)
	debuglog(_META, '/resources/CreantisJsFooter.js');
	executeMetaFunction(_META)
	debuglog({}, 'CaseModules');
}



function initFormatAllView() {
	//FormatDobleAllView();
	//FormatNumberAllView();
}


/**
 * Hook Js
 * Declarado en => layouts/v7/modules/Vtiger/resources/Vtiger.js => ln 889
 * Funcion que se ejecuta al al limpiar un campo de modulo relacional
 * @param {*} fieldName =>nombre del campo
 */
function ClearForX_ModuleReference(fieldName) {
	CLog.fn('ClearForX_ModuleReference', fieldName)

	switch (fieldName) {
		case 'marca_tks_cuenta':
			clearRelatedField('lb_contactcuenta');
		break;
		case 'lb_agenciadeediosmarca':
			clearRelatedField('lb_contactoagenciamedio');
		break;
		case 'lb_agenciadeelacionesublmarca_display':
			clearRelatedField('lb_contactoagenciarelapubli');
		break;
		case 'lb_agencialibremraca':
			clearRelatedField('lb_contactoagencialibre');
		break;
	}
}


/**
 * Hook Js
 * Declarado en => layouts/v7/modules/Vtiger/resources/Vtiger.js => ln 1542 :: registerPostReferenceEvent
 * Funcion que se ejecuta al realizar una accion en el campo de modulo relacional
 * @param {*} obj  => modulename, id, input_name
 */
function ReferenceFieldModuleGetDataCase(obj) {
	CLog.fn('ReferenceFieldModuleGetDataCase -> objref', obj);

	requestData(obj.modulerel, 'GetData', obj.idmodulerel)
		.then(function (data) {
			if (data['success']) {
				let dt = data.result.data;
				//console.log('AppConnector', dt);

				// Si el módulo actual es 'Accounts' y el registro fuente es de tipo 'Ubigeo'
				if (obj.module === "Accounts" && dt.record_module === "Ubigeo") {
					//(field) : comercial
					Ubigeo_GetData({
						departamento: { name: 'bill_pobox', value: dt.ubigeo_tks_departamento },
						distrito: { name: 'bill_city', value: dt.ubigeo_tks_distrito },
						provincia: { name: 'bill_state', value: dt.ubigeo_tks_provincia },
						pais: { name: 'bill_country', value: dt.ubigeo_tks_pais },
					});
				}

				// Si el módulo actual es 'Contacts' y el registro fuente es de tipo 'Ubigeo'
				if (obj.module === "Contacts" && dt.record_module === "Ubigeo")
					//(field) : comercial
					Ubigeo_GetData({
						departamento: { name: 'mailingpobox', value: dt.ubigeo_tks_departamento },
						distrito: { name: 'mailingcity', value: dt.ubigeo_tks_distrito },
						provincia: { name: 'mailingstate', value: dt.ubigeo_tks_provincia },
						pais: { name: 'mailingcountry', value: '' },
					});


				if (obj.module === "Marca" && dt.record_module === "Ubigeo")
					//(field) : comercial
					Ubigeo_GetData({
						departamento: { name: 'lb_departamentooficina', value: dt.ubigeo_tks_departamento },
						distrito: { name: 'lb_distritooficina', value: dt.ubigeo_tks_distrito },
						provincia: { name: 'lb_provinciaoficina', value: dt.ubigeo_tks_provincia },
						pais: { name: 'lb_paisoficina', value: dt.ubigeo_tks_pais },
					});
			}
		})

}


/**
 * Hook Js
 * Declarado en => layouts/v7/modules/Vtiger/resources/Detail.js::registerRelatedRowClickEvent => ln 673
 * Declarado en => layouts/v7/modules/Vtiger/resources/Edit.js::registerPageLeaveEvents => ln 350
 * Funcion que se ejecuta para traer el diccionario SC y bloquear campos 
 * @param {*} fieldName =>nombre del campo
 */
function EventsEditDetailModuleRelation(modulo, view, record) {
	CLog.fn('EventsEditDetailModuleRelation', modulo, view, record);
	initFormatAllView()
}


/**
 * Declarado en => layouts/v7/modules/Vtiger/resources/Detail.js => ln 747 :registerEventsForRelatedList
 * Funcion que se ejecuta despues de cargar una lista relacional
 */
function FinallyLoadListRel() {
	CLog.fn('FinallyLoadListRel')
	initFormatAllView()
	/*
	.finally( ()=>{
		//Creantis - cgarcia llamado despues de cargar una lista 
		if (typeof FinallyLoadListRel === 'function') FinallyLoadListRel();
		
	})
	debugger
*/
}

/**
 * Declarado en => layouts/v7/modules/Vtiger/resources/Detail.js => ln 1408 :registerAjaxEditSaveEvent
 * Funcion que se ejecuta despues de guardar de manera individual un campo
 */
function AffterSaveFieldValues(response) {
	CLog.fn('AffterSaveFieldValues')
	AffterSaveFieldValues()
}


/**
 * Declarado en => layouts/v7/modules/Inventory/resources/Edit.jss => ln 1607 :showLineItemPopup
 * Funcion que se ejecuta despues de cerrar el popup creado
 */
function PreFinallymapResultsToFields(data) {
	CLog.fn('PreFinallymapResultsToFields', data)
}

/**
 * Declarado en => layouts/v7/modules/Inventory/resources/Edit.jss => ln 1524 :mapResultsToFields
 * Funcion que se ejecuta despues de seleccionar el producto
 */
async function FinallymapResultsToFields(record, data) {
	CLog.fn('FinallymapResultsToFields', [record, data])
}

document.addEventListener("DOMContentLoaded", () => CaseModules(), initFormatAllView());
document.addEventListener("DOMContentLoaded", function (event) { });

/**
 * Funcion que se ejecuta despues de cargar un QuickCreate
 */
function clicOpenQuickCreate(form, data) {
	CLog.fn('clicOpenQuickCreate', { form: form, data: data, _META: _META });

	if (!data.fieldname) return false;
	if (document.querySelector('[name=firstname]'))document.querySelector('[name=firstname]').parentElement.style.display='flex'
	let evinfo = getFormValues('EditView')
	switch (data.fieldname) {
		case "lb_contactcuenta":
			// Se ejecuta cuando la cuenta existe y se selecciona el tipo de cuenta
			setValuesModal_QuickCreate(evinfo['marca_tks_cuenta'])
			fillRelatedField(form, evinfo, 'account_id', 'marca_tks_cuenta');
			break;
		case "lb_contactoagenciamedio":
			// Se ejecuta cuando la cuenta existe y se selecciona el tipo de cuenta
			setValuesModal_QuickCreate(evinfo['lb_agenciadeediosmarca'])
			fillRelatedField(form, evinfo, 'account_id', 'lb_agenciadeediosmarca');
			break;
		case "lb_contactoagenciarelapubli":
			// Se ejecuta cuando la cuenta existe y se selecciona el tipo de cuenta
			setValuesModal_QuickCreate(evinfo['lb_agenciadeelacionesublmarca'])
			fillRelatedField(form, evinfo, 'account_id', 'lb_agenciadeelacionesublmarca');
			break;
		case "lb_contactoagencialibre":
			// Se ejecuta cuando la cuenta existe y se selecciona el tipo de cuenta
			setValuesModal_QuickCreate(evinfo['lb_agencialibremraca'])
			fillRelatedField(form, evinfo, 'account_id', 'lb_agencialibremraca');
			break;
		case "lb_agenciadeediosmarca":
		case "lb_agenciadeelacionesublmarca":
		case "lb_agencialibremraca":
		case "lb_agencidemedios":
		case "lb_agencidelibre":
		case "lb_agenciderelacionespublicas":
			select2value(select('#QuickCreate [name="lb_tipoclientepinklist"]'), 'Agencia')
			elementReadonly(true, select('#QuickCreate [name="lb_tipoclientepinklist"]'))

			break;

			
	}

}

function setValuesModal_QuickCreate(recordid){
	if (!recordid) return false;

	requestData('Accounts', 'GetData', recordid)
	.then(function (data) {
		if (!data['success']) return false;
			let dt = data.result.data;
			//console.log('clicOpenQuickCreate', dt);

			if(dt.lb_tipoclientepinklist){
				select2value('[name=lb_tipocuentacontacto]', dt.lb_tipoclientepinklist);
				elementReadonly(true, select('[name=lb_tipocuentacontacto]'))
			} 

	})
}


/**
 * Disparador de eventos para el QuickCreate
 * editar tpl de referencia
 * layouts/v7/modules/Vtiger/uitypes/Reference.tpl => add  data-fieldname='{$FIELD_NAME}'
 */
document.addEventListener('click', function (e) {
	const target = e.target.closest('.input-group-addon:last-child');
	if (!target) return;

	// Obtener todos los atributos data-* como objeto
	const params = {};
	Array.from(target.attributes).forEach(attr => {
		if (attr.name.startsWith('data-')) {
			const key = attr.name.replace('data-', '').replace(/-([a-z])/g, (_, g) => g.toUpperCase());
			params[key] = attr.value;
		}
	});

	// Iniciar observador para detectar el formulario
	const observer = new MutationObserver((_, o) => {
		const form = document.querySelector('#QuickCreate');
		if (form) {
			if (typeof window.clicOpenQuickCreate === 'function') window.clicOpenQuickCreate(form, params);
			o.disconnect();
		}
	});

	observer.observe(document.body, { childList: true, subtree: true });
});


$('select[name=lb_tipoclientepinklist]').change(()=> validacion_tipoCuenta()); // ejecutar al escribir en el campo relacional

function validacion_tipoCuenta(){
	let dt = getFormValues('EditView')
	let lb_agencidelibre_display = select('[name="lb_agencidelibre_display"]')
	let lb_agencidemedios_display = select('[name="lb_agencidemedios_display"]')
	let lb_agenciderelacionespublicas_display = select('[name="lb_agenciderelacionespublicas_display"]')
	if(dt.lb_tipoclientepinklist === 'Agencia'){
		CampoRelacinaControlarDOM(lb_agencidemedios_display,0,0,0,0)
		CampoRelacinaControlarDOM(lb_agencidelibre_display,0,0,0,0)
		CampoRelacinaControlarDOM(lb_agenciderelacionespublicas_display,0,0,0,0)		
	}else{
		CampoRelacinaControlarDOM(lb_agencidemedios_display,1,1,1,1)
		CampoRelacinaControlarDOM(lb_agencidelibre_display,1,1,1,1)
		CampoRelacinaControlarDOM(lb_agenciderelacionespublicas_display,1,1,1,1)
	}
	
}