class CLog {
	static debug = false;

	static setDebug(show) {
		CLog.debug = show;
	  }

	static error(message , text ='') {
	 	if(CLog.debug) console.log(`%cERROR: %c${message}`, "color: red", "color: inherit",text);
	}
  
	static warning(message , text ='') {
	 	if(CLog.debug)  console.log(`%cWARNING: %c${message}`, "color: orange", "color: inherit",text);
	}
  
	static info(message , text ='') {
	 	if(CLog.debug)  console.log(`%cINFO: %c${message}`, "color: blue", "color: inherit",text);
	}
  
	static success(message , text ='') {
	 	if(CLog.debug)  console.log(`%cSUCCESS: %c${message}`, "color: green", "color: inherit",text);
	}

	static log(message , text ='') {
		if(CLog.debug)  console.log(`%cLOG: %c${message}`, "color: grey", "color: inherit",text);
   	}
  
  static fn(message , text ='') {
    if(CLog.debug)  console.log(`%cFUNCTION: %c${message}`, "color: cyan", "color: inherit",text);
    }
  }
  
  /* Ejemplo de uso:
  CLog.error("Este es un mensaje de error");
  CLog.warning("Este es un mensaje de advertencia");
  CLog.info("Este es un mensaje informativo");
  CLog.success("Este es un mensaje de éxito");
  //*/


/*
* Create function globlal Js Add for Creantis Vtiger 7.5 header page
* Actualizacion 2023-03-23
*/
var DEBUG=false; // => para imprimir el contenido de la funcion
var DEBUGF=true; // => para imprimir nombre de la funcion
/**
 * Simplifigar el console.log
 * ejecutar=> log("Hello world!");
 */
const { log } = console;



/**
 * Print en consola  
 * @param {Object} obj  =>valor que se imprime en consola
 * @param {string} funcion =>pasar el nombre de la funcion (opcional)
 */
const debuglog = (obj, funcion = '') =>  {
    let dfuncion='';
    if(funcion && DEBUGF)dfuncion=funcion
    if(obj && DEBUG)console.log(`${dfuncion}`,obj)
}



/**
 * [Simplifidar el document.querySelector]
 * @param  {[string]} selector [selector del elemento]
 * @param  {[string]} scope    [opcional elemnto del formulario]
 * @return {[elemento]}          [selector]
 */
const select = (selector, scope = document) => {
  return scope.querySelector(selector);
};


/**
 * para modificar el valor de un select2 o picklist en el campo del formulario
 * @param {string} selector => [name=campo]
 * @param {string} value => valor del campo
 * @requiere Libreria Jquery
 */
const select2value = (selector, value) => {
  value= (value)?value:'';
  $(selector).val(value); // Change the value or make some change to the internal state
  $(selector).trigger('change');
};

/**
 * [verificar si los valores de un array tiene al menos un '0']
 * @param  {[array]}  arr [valores]
 * @return {Boolean}     [true si encuentra algun 0]
 *  */
function hasZero(arr) {
    return arr.some(val => val === '0');
}



/**
 * [obtener los valores de una columna específica en una tabla]
 * @param  {[string]} tableId     [id de la tabla]
 * @param  {[int]} columnIndex [numero de columna a extraer]
 * @return {[array]}             [valores de la columna]
 */
const getColumnValues = (tableId, columnIndex) => {
  const table = document.getElementById(tableId);
  const tbody = table.querySelector("tbody");
  const rows = tbody.querySelectorAll("tr");

  return Array.from(rows).map(row => {
    const cells = row.querySelectorAll("td");
    return cells[columnIndex].textContent;
  });
}



/**
 * [función solo seleccionará los inputs de tipo checkbox]
 * @param  {[type]} formId [id del formulario]
 */
const checkAllInputs=(formId)=> {
  const form = document.getElementById(formId);
  const inputs = form.querySelectorAll("input");
  inputs.forEach(input => input.checked = true);
}



/**
 * [isObjectEmpty Para verificar si un objeto tiene un valor vacío en JavaScript, puedes usar la función Object.values() para obtener todos los valores del objeto y luego verificar si alguno de ellos es undefined o una cadena vacía.]
 * @param  {[type]}  obj) {             return Object.values(obj).every(val [description]
 * @return {Boolean}      [True si es vacio or false si esta lleno]
 */
const isObjectEmpty = (obj)=> {  
  return Object.values(obj).every(val => val === undefined || val === "");
}

/**
 * comprobar si un objeto tiene alguna propiedad que tenga un valor vacío
 * @param {*} obj 
 * @returns 
 */
const hasEmptyPropertyValue = (obj) => {
  return Object.values(obj).some((val) => val === undefined || val === "");
};


/**
 * [removeProperties devuelve un nuevo objeto sin las propiedades que pases por array]
 * @param  {[type]} obj   [objeto que se va copiar para eliminar las propiedades]
 * @param  {[type]} props [array con propiedades que se van a eliminar]
 * @return {[type]}       [nuevo objeto sin las propiedades ]
 */
const removeProperties=(obj, props) =>{
  const newObj = {...obj};
  for (let prop of props) {
    delete newObj[prop];
  }
  return newObj;
}



/**
 * [getFormValues Para obtener los valores de un formulario que contenga diferentes tipos de elementos, como select, input, radio y checkbox, ]
 * @param  {[string]} formid [id del formulario]
 * @return {[obj]}      [objeto]
 */
function getFormValues(formId) {
  const form = document.getElementById(formId);
  const formValues = {};
  
  Array.from(form.elements).forEach(element => {
    if (element.name && !element.disabled) {
      if (element.tagName === 'SELECT') {
        const selectedOptions = Array.from(element.options)
          .filter(option => option.selected);
  
        if (selectedOptions.length === 1) {
          const selectedOption = selectedOptions[0];
          formValues[element.name] = selectedOption.value;
  
          // Extract data attributes from selected option
          const attributes = Array.from(selectedOption.attributes);
          attributes.forEach(attribute => {
            if (attribute.name.startsWith('data-')) {
              const attributeName = attribute.name.replace('data-', '');
              formValues[attributeName] = attribute.value;
            }
          });
        } else if (selectedOptions.length > 1) {
          // Ensure array initialization for multiple selections
          formValues[element.name] = selectedOptions.map(option => option.value);
  
          // Extract data attributes for multiple selections
          selectedOptions.forEach(option => {
            const attributes = Array.from(option.attributes);
            attributes.forEach(attribute => {
              if (attribute.name.startsWith('data-')) {
                const attributeName = attribute.name.replace('data-', '');
                
                // Initialize as array if not exists
                if (!Array.isArray(formValues[attributeName])) {
                  formValues[attributeName] = [];
                }
                
                formValues[attributeName].push(attribute.value);
              }
            });
          });
        }
      } else if (element.type === 'checkbox' || element.type === 'radio') {
        if (element.checked) {
          // Initialize as array if not exists
          if (!Array.isArray(formValues[element.name])) {
            formValues[element.name] = [];
          }
          formValues[element.name].push(element.value);
        }
      } else {
        formValues[element.name] = element.value;
      }
    }
  });
  
  return formValues;
}


/**
 * [asignar los valores de un objeto a los elementos de un formulario, recorre cada elemento 'name' del formulario y asigne el valor correspondiente del objeto]
 * @param  {[string]} formid [id del formulario]
 * @param  {[obj]} values [objeto]
 */
const setFormValues = (formid, values) => 
  Array.from(document.getElementById(formid).elements).forEach(element => {
    if (!values.hasOwnProperty(element.name)) return;
    if (element.type === "select-one" || element.type === "select-multiple") {
      Array.from(element.options).forEach(
        option => option.selected = values[element.name].includes(option.value)
      );
    } else if (element.type === "checkbox" || element.type === "radio") {
      element.checked = values[element.name] === element.value;
    } else {
      element.value = values[element.name];
    }
  });




/**
 * [resetForm limpia los valores de los elementos de un formulario que sean diferentes a hidden y submit]
 * @param  {[string]} formid [id del formulario]
 */
const resetForm = (formId) => {
  Array.from(document.getElementById(formId).elements).forEach((element) => {
    if (
      (element.type !== "hidden" && element.type !== "submit") // Excluir campos hidden y submit
    ) {
      if (element.type === "select-one" || element.type === "select-multiple") {
        Array.from(element.options).forEach(
          (option) => (option.selected = false)
        );
      } else if (element.type === "checkbox" || element.type === "radio") {
        element.checked = false;
      } else {
        element.value = "";
      }
    }
  });
};



/**
 * [obtenerDatosJson obtienes los datos en json desde el fetch]
 * @param  {[string]} url [description]
 * @return {[json]}     [description]
 */
const obtenerDatosJson = async (url) => {
  const response = await fetch(url);
  if (response.ok) {
      try {
        const datos = await response.json();
         return datos;
      } catch (error) {
          const response = await fetch(url);
          let text = await response.text();
          console.error(error,text);
      }
  } else {
    throw new Error("Error al obtener los datos");  
  }

};



/**
 * Cambia el formato de la fecha a YYYY-mm-dd
 * @param {'dd-mm-YYYY'} fecha [string]
 * @returns [objeto]
 */
const changeFormaFechaYearMonthDay = (fecha) =>  {
    let objDate={}
    fecha=fecha.toString();
    const [dia, mes, year] = fecha.split('-');
    objDate.yyyy_mm_dd = `${year}-${mes.padStart(2, '0')}-${dia.padStart(2, '0')}`;
    objDate.year = year
    objDate.mes = mes.padStart(2, '0')
    objDate.dia = dia.padStart(2, '0')

    objDate.date = new Date(objDate.yyyy_mm_dd);
    objDate.toISOString = new Date(objDate.yyyy_mm_dd).toISOString()
    return objDate;
  };



/**
 * Calcula los dias y semanas entre dos fechas
 * @param {'YYYY-mm-dd'} fecha1 [string]
 * @param {'YYYY-mm-dd'} fecha2 [string]
 * @returns [objeto]
 */
const calcularNumeroSemana=(fecha1, fecha2)=> {
    let objDate={}
     objDate.dateISO1 = new Date(fecha1.toString() + "T00:00:00-05:00").toISOString();
     objDate.dateISO2 = new Date(fecha2.toString() + "T00:00:00-05:00").toISOString();
     objDate.fechaDesde = new Date(objDate.dateISO1)
     objDate.fechaHasta = new Date(objDate.dateISO2)
    
    const diferenciaMs = objDate.fechaHasta - objDate.fechaDesde;
    const msEnSemana = 1000 * 60 * 60 * 24 * 7;
     objDate.semanasCompletas = Math.floor(diferenciaMs / msEnSemana);
     objDate.diasRestantes = Math.floor((diferenciaMs % msEnSemana) / (1000 * 60 * 60 * 24));
    return objDate
};



/**
 * obtienes el primer dia del año de la 'fecha'
 * @param {'YYYY-mm-dd'} fecha [string]
 * @returns {'YYYY-mm-dd'} [string] =>
 */
function primerDiaDelYear(fecha) {
    const year = fecha.split("-")[0];
    const primerDia = `${year}-01-01`;
    return primerDia;
  }



  function quitarComas(valor) {
    if (typeof valor === 'string') {
      // Reemplazar todas las comas por una cadena vacía
      return valor.replace(/,/g, '');
    } else {
      return valor;
    }
  }
  


/**
 * remueve de la lista del select2 el optgroup
 * @param {string} label nombre del label de optgroup
 */
function removeSelectOptgroup(label){
  document.querySelector(`#viewColumnsSelect > optgroup[label="${label}"]`).remove()
  //document.querySelector('#viewColumnsSelect > optgroup[label="Información de la tarea"]').remove()
}        



/**
 * Manipulacion de DOM elements para habilitar readonly bajo style vtiger
 * @param {booleano} readOnly => true || false
 * @param {element} element => select("[name=accountname]")
 */
const elementReadonly = (readOnly, element) => {
  if(element){
  element.readOnly = readOnly;
  element.style.background = readOnly ? "#eee" : "white";
  }
};



/**
 * Manipulacion de DOM elements para habilitar required
 * @param {booleano} required => true || false
 * @param {element} element => select("[name=accountname]")
 */
const elementRequired = (required, element) => {
  if(element){
    element.required = required;
      let value = element.parentNode.previousElementSibling.innerHTML
      let span = element.parentNode.previousElementSibling.querySelector('span')
    if(required && !span){
      element.parentNode.previousElementSibling.innerHTML = `${value} <span class="redColor">*</span>`;
    }
    if(!required && span){
      element.parentNode.previousElementSibling.innerHTML = value.replace(' <span class="redColor">*</span>', '');
    }
  }
};



/** 
 * Para obtener el texto de la opción seleccionada en un elemento con el atributo name
 * @param {string} selectName => 'accountname'
 */
  const getSelectedOptionText = (selectName) => {
    let selectElement = document.querySelector(`#QuickCreate`);
    if(document.querySelector(`#QuickCreate`)){
      selectElement= selectElement.querySelector(`[name='${selectName}']`);
    }else{
      selectElement = document.querySelector(`[name='${selectName}']`);
    }
    const selectedOption = selectElement.options[selectElement.selectedIndex];
    return selectedOption.text;
  }



  
  /**
   * Manipulas el input del campo relacional para pasar valores
   * @param {*} value => LLenar con el id para mandarlo por el formulario
   * @param {string} text => llenar el input con el nombre a mostrar
   * @param {Element} selector => select('campo')
   */
  const showReferenceSelection=(value,text, selector) => {
    if(!selector)return false;
    let obj={} 
    const hiddenInput = selector.parentElement.childNodes[0];
    const visibleInput = selector;
    const btnx = selector.parentElement.childNodes[2];
  
  
  
    hiddenInput.value = value;
    visibleInput.value = text;
    if(value){
    obj.disable=true
    visibleInput.setAttribute('disabled', 'disabled');
    btnx.classList.remove('hide');
    }else{
    obj.disable=false
    visibleInput.removeAttribute('disabled');
    btnx.classList.add('hide');
    }
    debuglog( obj,'showReferenceSelection');
  }
  


/**
 * Manipular el DOM de la vista segun sea el caso para el campo relacional
 *  -TRUE (verLupa,verPlus)=> para ver campo y FALSE para ocultarlo 
 *  -TRUE (input)=> disabled y FALSE para quitar el disabled
 * @param {Element} selector  => select('campo')
 * @param {Boolean} verLupa => lupa del campo relacional
 * @param {Boolean} verPlus => agregar del campo relacional
 * @param {Boolean} input => campo de texto del campo relacional
 */
const CampoRelacinaControlarDOM=(selector, verLupa = true, verPlus = true, input = true, clickX = true)=>{
  if(!selector)return false;

  const btnX = selector.parentElement.childNodes[2];
  const Lupa = selector.parentElement.childNodes[3];
  const plus = selector.parentElement.childNodes[4];


  if(!input){
    if(clickX){ 
      btnX.click();
    }else{
      btnX.classList.add('hide')
      log('paso')
    };

    selector.setAttribute('disabled', 'disabled')
    }else{
      selector.removeAttribute('disabled')
    };
  (!verLupa)?Lupa.classList.add('hide'): Lupa.classList.remove('hide');
  (!verPlus)?plus.classList.add('hide'): plus.classList.remove('hide');

}



  function buscarPalabra(cadena, palabra) {
    return cadena.toUpperCase().includes(palabra.toUpperCase());
  }



  /**
   * para sumar year a la fecha original
   * @param {'dd-mm-YYYY'} fecha [string]
   * @param {Integer} dias 
   * @returns {'dd-mm-YYYY'} + {dias}
   */
  function sumarAnios(fecha, anios) {
    // Separar la fecha en día, mes y año
    const [day, month, year] = fecha.split("-");
    const resultado = new Date(year, month - 1, day);
    resultado.setFullYear(resultado.getFullYear() + anios);
    const newYear = resultado.getFullYear();
    const newMonth = resultado.getMonth() + 1;
    const newDay = resultado.getDate();
    return `${newDay.toString().padStart(2, '0')}-${newMonth.toString().padStart(2, '0')}-${newYear.toString()}`;
  }
  
  
  
  
  

  /**
   * Voltear formato de fecha
   * @param {'YYYY-mm-dd'} fecha 
   * @returns {'dd-mm-YYYY'} + {dias}
   */
  function convertDateDayMesYear(fecha) {
    // Separar los componentes de la fecha y formatear en el orden deseado
    return fecha.split('-').reverse().join('-');
  }



  /**
 * Valida un número de DNI (Documento Nacional de Identidad) en Argentina.
 * @param {string} data - El número de DNI a validar.
 * @returns {boolean} Verdadero si el número de DNI es válido, falso de lo contrario.
 */
function validateDNI(data) {
  const dni = data.replace('-', '').trim().toUpperCase();
  if (!dni || dni.length < 9) {
    return false;
  }
  
  const multiples = [3, 2, 7, 6, 5, 4, 3, 2];
  const dcontrols = {
    numbers: [6, 7, 8, 9, 0, 1, 1, 2, 3, 4, 5],
    letters: ['K', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J']
  };
  
  const numdni = dni.substring(0, dni.length - 1).split('');
  const dcontrol = dni.substring(dni.length - 1);
  
  const dsum = numdni.reduce((acc, digit, index) => {
    acc += digit * multiples[index];
    return acc;
  }, 0);
  
  const key = 11 - (dsum % 11);
  const index = (key === 11) ? 0 : key;
  
  if (/^\d+$/.test(dni)) {
    return dcontrols.numbers[index] === parseInt(dcontrol, 10);
  }
  
  return dcontrols.letters[index] === dcontrol;
  }
  



  /**
   * Valida un número de RUC (Registro Único de Contribuyentes) en Perú.
   * @param {number} ruc - El número de RUC a validar.
   * @returns {boolean} Verdadero si el número de RUC es válido, falso de lo contrario.
   */
  function rucValido(ruc) {
  var ruc_s = ruc + "";
  let ultimodigito = parseInt(ruc) % 10;
  
  if (!(ruc >= 1e10 && ruc < 11e9 || ruc >= 15e9 && ruc < 18e9 || ruc >= 2e10 && ruc < 21e9)) {
    return false;
  }
  
  const arr = [5, 4, 3, 2, 7, 6, 5, 4, 3, 2];
  let suma = 0;
  
  for (var i = 0; i < 10; i++) {
    suma += ruc_s[i] * arr[i];
  }
  
  let resta = parseInt(suma / 11);
  let x1 = 11 - (suma - resta * 11);
  
  return (x1 < 10) ? x1 === ultimodigito : x1 % 10 === ultimodigito;
  }


  
/**
 * Perform a data request using AppConnector.
 * @param {string} module - The target module.
 * @param {string} action - The action to perform.
 * @param {string} record - The record ID.
 * @returns {Promise} - A promise that resolves with the response data.
 */
function requestData(module, action, record) {
  const requestUrl = `index.php?module=${module}&action=${action}&record=${record}&source_module=${module}`;
  return AppConnector.request(requestUrl);
}


/** 
 * Registra y configura un editor CKEditor en un elemento específico.
 * @param {string} elementSelector - Selector del elemento en el que se desea instanciar CKEditor.
 * @param {object} config - Configuración personalizada para el editor CKEditor.
 */
function registerCkEditor(elementSelector, config) {
  var ckEditorInstance = new Vtiger_CkEditor_Js();
  var element = jQuery(elementSelector);
  
  if (element.length > 0) {
      if (jQuery('#EditView').find('.isSystemTemplate').val() == 1) {
          element.removeAttr('data-validation-engine').addClass('ckEditorSource');
      }
      
      ckEditorInstance.loadCkEditor(element, config);
  }
console.log('registerCkEditor')
}

/**
 * Elimina los elementos hijos que tienen una clase específica de un elemento padre.
 * También agrega estilo 'font-weight: 900;color:darkgrey;' a los elementos con la clase 'value'.
 *
 * @param {string} parentId - El ID del elemento padre.
 * @param {string} className - La clase que deben tener los elementos hijos a eliminar.
 */
function removeElementsWithClassFromChildren(parentId, className) {
  const parentElement = document.getElementById(parentId);
  if (parentElement) {
    const children = parentElement.getElementsByClassName(className);
    const childrenValue = parentElement.getElementsByClassName('value');


    // Convierte la colección HTML en un array para poder recorrerla y eliminar los elementos
    const childrenArray = Array.from(children);
    const childrenValueArray = Array.from(childrenValue);

    childrenArray.forEach(child => {

      child.remove();
    });
    childrenValueArray.forEach(childv => {
      childv.style.fontWeight = '900';
     // childv.style.color = 'darkgrey';
    });
  }
}



/**
 * Agrega un elemento <li> con un enlace interno (<a>) a un menú desplegable de la vista detalle.
 *
 * @param {string} linkText - El texto del enlace.
 * @param {string} linkUrl - La URL del enlace.
 * @param {string} [liId] - (Opcional) El ID del elemento <li> a agregar.
 */
function addListItemToDropdownMenuDetail(linkText, linkUrl, liId) {
  // Obtén el elemento ul por su clase
  const ulElement = document.querySelector('.dropdown-menu.dropdown-menu-right');

  if (ulElement) {
    // Crea un nuevo elemento li
    const newLiElement = document.createElement('li');

    // Asigna un ID al nuevo elemento li si se proporciona
    if (liId) {
      newLiElement.id = liId;
    }

    // Crea un nuevo elemento ancla (<a>)
    const newLinkElement = document.createElement('a');

    // Asigna un enlace y texto al nuevo elemento ancla
    newLinkElement.href = linkUrl;
    newLinkElement.textContent = linkText;

    // Agrega el nuevo elemento ancla al nuevo elemento li
    newLiElement.appendChild(newLinkElement);

    // Agrega el nuevo elemento li al final de la lista ul
    ulElement.appendChild(newLiElement);
  }
}



/**
 * Habilita o deshabilita un elemento de formulario o lo hace de solo lectura.
 *
 * @param {HTMLElement} element - El elemento de formulario al que se aplicará la habilitación o solo lectura.
 * @param {boolean} isDisabled - True para deshabilitar el elemento, False para habilitarlo.
 * @returns {void}
 */
function setElementDisabledOrReadonly(element, isDisabled) {
  if (!element) return;
  element.disabled = isDisabled;
  removeElementsIfNameContains(element);
}

/**
* Elimina elementos con clases específicas de elementos cuyo atributo "name" contiene "_display".
*
* @param {HTMLElement} element - El elemento de formulario cuyo atributo "name" se verifica para eliminar elementos.
* @returns {void}
*/
function removeElementsIfNameContains(element) {
  // Obtén el elemento padre
  const parentElement = element.parentElement;

  // Obtén todos los elementos con las clases que deseas eliminar
  const elementsToRemove = parentElement.querySelectorAll('.clearReferenceSelection, .relatedPopup, .createReferenceRecord');

  // Elimina los elementos si el nombre del elemento contiene "_display"
  if (element.name.includes('_display')) {
      elementsToRemove.forEach(element => {
          element.remove();
      });
  }
}




/**
 * Verifica si un archivo JavaScript existe en la URL especificada.
 *
 * @param {string} url - La URL del archivo a verificar.
 * @returns {Promise<boolean>} - Una promesa que resuelve a `true` si el archivo existe, o `false` en caso contrario.
 */
function archivoHEADExiste(url) {
  return fetch(url, { method: 'HEAD' })
      .then(response => {
          return response.status === 200;
      })
      .catch(error => {
          return false;
      });
}



/**
* Carga un archivo JavaScript en el encabezado de la página si existe.
*
* @dependencia function archivoHEADExiste();
* @param {string} archivoURL - La URL del archivo a cargar.
* @param {Function} callback - La función que se ejecutará cuando el archivo esté cargado.
*/
function cargarArchivoJS(archivoURL, callback) {
    archivoHEADExiste(archivoURL)
        .then(existe => {
            if (existe) {
                const scriptElement = document.createElement('script');
                scriptElement.src = archivoURL;
                scriptElement.async = true;

                // Agregar un evento 'error' para manejar la carga fallida sin mostrar errores en la consola
                scriptElement.onerror = function() {
                    // Puedes realizar acciones adicionales aquí si lo deseas
                    CLog.log('Error al cargar el archivo:', archivoURL);
                };

                // Agregar un evento 'load' para ejecutar la función de callback cuando el archivo esté cargado
                scriptElement.onload = callback;

                document.head.appendChild(scriptElement);
            } else {
                CLog.log('El archivo no existe.');
            }
        })
        .catch(error => {
          CLog.error('Error al verificar la existencia del archivo:', error);
        });
}
// Llamar a cargarArchivoJS con una función de callback que se ejecutará cuando el archivo esté cargado
document.addEventListener('DOMContentLoaded', cargarArchivoJS(`complemento/module/validaciones/controller/validaciones.js?v=${Math.floor(Math.random() * 1000) + 1}`, () => { } ) );


function addBtnInput(parentSelector, title, icon = 'fa fa-refresh') {
  // Selecciona el elemento padre
  var parentElement = document.querySelector(parentSelector).parentElement;
  
  // Crea el nuevo elemento con el contenido HTML predeterminado
  var nuevoElemento = document.createElement('span');
  nuevoElemento.className = 'input-group-addon';
  nuevoElemento.title = title;
  nuevoElemento.innerHTML = `<i class="${icon}"></i>`;

  // Agrega el estilo hover al elemento
  nuevoElemento.style.cursor = 'pointer'; // Cambia el cursor al pasar sobre el elemento
  nuevoElemento.style.transition = 'background 0.3s ease-in-out'; // Transición suave para el cambio de color de fondo
  if(icon != 'fa fa-refresh')nuevoElemento.style.display = 'inline'; // Transición suave para el cambio de color de fondo

  // Agrega el evento de hover al elemento
  nuevoElemento.addEventListener('mouseenter', function() {
      nuevoElemento.style.backgroundColor = 'lightgrey'; // Cambia el color de fondo al pasar el ratón por encima
  });

  nuevoElemento.addEventListener('mouseleave', function() {
      nuevoElemento.style.backgroundColor = ''; // Restaura el color de fondo al quitar el ratón
  });
  
  // Agrega el nuevo elemento al principio del elemento padre
  parentElement.insertBefore(nuevoElemento, parentElement.firstChild);
}


   function agregarIconoAyuda(elementoPadre, funcionAyuda) {
        // Crear el elemento <i> con la clase "fa fa-question-circle" y agregar el evento onclick
        var iconoAyuda = document.createElement("i");
        iconoAyuda.classList.add("fa", "fa-question-circle");
        iconoAyuda.onclick = funcionAyuda;

        // Agregar el icono dentro del elemento especificado
        elementoPadre.appendChild(iconoAyuda);
    }


    /**
 * Agrega un nuevo botón antes de un elemento específico.
 * 
 * @param {string} textoBoton - El texto que se mostrará en el botón.
 * @param {string} selector - Selector CSS del elemento antes del cual se insertará el botón.
 * @param {string} botonId - ID que se asignará al nuevo botón.
 * @param {Array.<string>} clasesAdicionales - Lista de clases adicionales a agregar al botón.
 * @param {string} [onClickAttr] - Atributo onclick opcional a agregar al botón.
 */
function agregarBoton(textoBoton, selector, botonId, clasesAdicionales, onClickAttr) {
  // Verificar si el botón ya existe
  if (!document.getElementById(botonId)) {
      // Crear el botón
      var nuevoBoton = document.createElement('button');
      nuevoBoton.className = 'btn btn-default ' + clasesAdicionales.join(' ');
      nuevoBoton.id = botonId;
      nuevoBoton.textContent = textoBoton;

      // Agregar el atributo onclick al botón, si se proporciona
      if (onClickAttr) {
          nuevoBoton.setAttribute('onclick', 'javascript:'+onClickAttr);
      }

      // Obtener el contenedor para el nuevo botón
      var elemento = document.querySelector(selector);

      if (elemento) {
          // Insertar el botón antes del elemento indicado
          elemento.parentNode.insertBefore(nuevoBoton, elemento);
      } else {
          console.error('El selector proporcionado no coincide con ningún elemento en el documento.');
      }
  }
}



// Variable para almacenar el interval ID
var intervalId;

// Función para deshabilitar todos los checkboxes
function disableCheckboxes() {
    var checkboxes = document.querySelectorAll('input[type="checkbox"]');
    checkboxes.forEach(function(checkbox) {
        checkbox.disabled = true;
    });
}

// Función para habilitar todos los checkboxes
function enableCheckboxes() {
    var checkboxes = document.querySelectorAll('input[type="checkbox"]');
    checkboxes.forEach(function(checkbox) {
        checkbox.disabled = false;
    });
}

// Ejecutar disableCheckboxes continuamente hasta que la página termine de cargar
    intervalId = setInterval(disableCheckboxes, 100); // 100 ms intervalo

// Habilitar todos los checkboxes y limpiar el interval cuando la página haya terminado de cargar
window.addEventListener('load', function() {
    clearInterval(intervalId); // Detener el setInterval
    enableCheckboxes(); // Habilitar todos los checkboxes
});



/**
 * Agrega CSS al documento.
 *
 * Esta función permite agregar estilos CSS a un documento HTML
 * insertando una etiqueta <style> en la cabecera del documento.
 *
 * @param {string} css - La cadena de texto que contiene los estilos CSS a agregar.
 *
 * @example
 * // Agregar estilo CSS para un botón con ID 'sendSIIGOInvoice'
 * addCSS(`
 *     button#sendSIIGOInvoice {
 *         background: deepskyblue;
 *         color: white;
 *     }
 * `);
 */
function addCSS(css) {
  let head = document.head || document.getElementsByTagName('head')[0];
  let style = document.createElement('style');

  style.type = 'text/css';
  if (style.styleSheet) {
      // Esto es para IE8 y anteriores
      style.styleSheet.cssText = css;
  } else {
      style.appendChild(document.createTextNode(css));
  }

  head.appendChild(style);
}


/**
 * Adds a modal header with a given title after the specified modal content element.
 * 
 * @param {string} title - The title to display in the modal header.
 * @param {string} className - The class name to select the specific modal content element.
 */
function addModalHeader(title, className) {
  setTimeout( () =>{
  document.querySelector('[data-bb-handler="ok"]').innerText = 'Cancelar'
  var modalContent = document.querySelector(`[role="dialog"][style="display: block;"] .modal-content ${className}`);
  
  if (!modalContent) return 
      var modalHeader = document.createElement('div');
      modalHeader.className = 'modal-header';
      modalHeader.innerHTML = `
          <div class="clearfix">
              <div class="pull-right">
              </div>
              <h4 class="pull-left">${title}</h4>
          </div>
      `;
      
      modalContent.parentNode.insertBefore(modalHeader, modalContent) 
    },500)
  
}


/**
 * Clona las opciones de un select de origen y las agrega a un select de destino, excluyendo la opción seleccionada.
 * @param {string} sourceName - El nombre del atributo data-fieldname del select de origen.
 * @param {string} destinationName - El valor del atributo name del select de destino.
 * @returns {void}
 */
function clonePicklistMultiselector(sourceName, destinationName) {
  // Obtener el select de origen
  var selectSource = document.querySelector('[data-fieldname="' + sourceName + '"]');
  
  // Obtener el select de destino
  var selectDestination = document.querySelector('[name="' + destinationName + '"]');
  
  // Verificar si ambos selectores existen
  if (selectSource && selectDestination) {
      // Limpiar el select de destino antes de clonar opciones
      selectDestination.innerHTML = '';
      
      // Obtener el valor seleccionado del select de origen
      var selectedValue = selectSource.value;
      
      // Iterar sobre las opciones del select de origen
      selectSource.querySelectorAll('option').forEach(function(option) {
          // Si la opción no es la seleccionada, clonarla y agregarla al select de destino
          if (option.value !== selectedValue) {
              var clonedOption = option.cloneNode(true);
              selectDestination.appendChild(clonedOption);
          }
      });
  } else {
      console.error('No se encontraron los selectores especificados.');
  }
}


function addHiddenInput(containerId, inputName, inputValue) {
  // Obtener el div por su ID
  var container = document.getElementById(containerId);

  // Verificar que el contenedor exista
  if (container) {
      // Crear el input hidden
      var hiddenInput = document.createElement('input');
      hiddenInput.type = 'hidden';
      hiddenInput.name = inputName;
      hiddenInput.value = inputValue;

      // Insertar el input hidden dentro del div
      container.appendChild(hiddenInput);
  } else {
      console.error('Contenedor con ID ' + containerId + ' no encontrado.');
  }
}



/**
 * Llena y controla un campo relacionado (como account_id, contact_id, etc.) en un formulario,
 * deshabilitando su input visible y ocultando el botón de búsqueda si ya se proporcionó un valor desde view_val.
 *
 * @param {HTMLFormElement} form - El formulario donde se encuentra el campo.
 * @param {Object} view_val - Objeto con los valores que se desean aplicar al formulario.
 * @param {string} fieldKey - El nombre del campo en el formulario (ej. "account_id").
 * @param {string} [sourceKey=fieldKey] - El nombre de la clave en view_val (por defecto igual a fieldKey).
 */
function fillRelatedField(form, view_val, fieldKey, sourceKey = fieldKey) {
  const hiddenField = form.querySelector(`[name="${fieldKey}"]`);
  const displayField = form.querySelector(`[name="${fieldKey}_display"]`);
  const popupBtn = displayField?.parentElement?.querySelector('.relatedPopup');

  if (!hiddenField || !displayField || !popupBtn) return;

  if (view_val[sourceKey]) {
      const sourceInput = document.querySelector(`[name="${sourceKey}"]`);
      let displayValue = '';
  
  requestData('Accounts', 'GetData', view_val[sourceKey])
  .then(function (data) {
    if (!data['success']) return false;

      let dt = data.result.data;
      displayValue = dt.label;
      hiddenField.type = 'text';
      hiddenField.value = view_val[sourceKey];
      hiddenField.type = 'hidden';
  
      displayField.value = displayValue || sourceInput?.dataset.displayvalue || '';
      displayField.disabled = true;
      popupBtn.style.display = 'none';
  })


 
  } else {
      hiddenField.type = 'text';
      hiddenField.value = '';
      hiddenField.type = 'hidden';

      displayField.value = '';
      displayField.disabled = false;
      popupBtn.style.display = 'masonry';
  }
}


/**
* Limpia un campo relacional en formularios tipo Vtiger (por ejemplo, contact_id, account_id).
* Simula un clic en el botón .clearReferenceSelection si existe.
*
* @param {string} fieldKey - El nombre base del campo (ej. "contactcuenta" si el input se llama "lb_contactcuenta_display").
*/
function clearRelatedField(fieldKey) {
  const displayInput = document.querySelector(`[name="${fieldKey}_display"]`);
  if (!displayInput) return;

  const clearBtn = displayInput.parentElement.querySelector('.clearReferenceSelection');
  if (clearBtn) clearBtn.click();
}